/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.shrinkwrap.resolver.api.CoordinateParseException;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RejectDependenciesFilter
implements MavenResolutionFilter {
    private final Set<MavenDependency> bannedDependencies;

    public RejectDependenciesFilter(String ... coordinates) throws IllegalArgumentException, CoordinateParseException {
        if (coordinates == null || coordinates.length == 0) {
            throw new IllegalArgumentException("There must be at least one coordinate specified to be rejected.");
        }
        HashSet<MavenDependency> bannedDependencies = new HashSet<MavenDependency>(coordinates.length);
        for (String coords : coordinates) {
            MavenCoordinate coordinate = MavenCoordinates.createCoordinate(coords);
            MavenDependency dependency = MavenDependencies.createDependency(coordinate, ScopeType.COMPILE, false, new MavenDependencyExclusion[0]);
            bannedDependencies.add(dependency);
        }
        this.bannedDependencies = Collections.unmodifiableSet(bannedDependencies);
    }

    @Override
    public boolean accepts(MavenDependency dependency, List<MavenDependency> dependenciesForResolution) {
        return !this.bannedDependencies.contains(dependency);
    }
}

