/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven.strategy;

import java.util.Arrays;
import java.util.HashSet;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.maven.filter.ScopeFilter;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionFilterUtil;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;

public final class AcceptScopesStrategy
implements MavenResolutionStrategy {
    private final MavenResolutionFilter[] resolutionFilters;

    public AcceptScopesStrategy(ScopeType ... scopes) throws IllegalArgumentException {
        if (scopes == null || scopes.length == 0) {
            throw new IllegalArgumentException("at least one scope must be specified");
        }
        HashSet<ScopeType> allowedScopes = new HashSet<ScopeType>(scopes.length);
        allowedScopes.addAll(Arrays.asList(scopes));
        this.resolutionFilters = new MavenResolutionFilter[]{new ScopeFilter(allowedScopes.toArray(new ScopeType[0]))};
    }

    public MavenResolutionFilter[] getPreResolutionFilters() {
        return MavenResolutionFilterUtil.getEmptyChain();
    }

    public MavenResolutionFilter[] getResolutionFilters() {
        return this.resolutionFilters;
    }
}

