/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven;

public class PackagingType {
    public static final PackagingType POM = PackagingType.of("pom");
    public static final PackagingType JAR = PackagingType.of("jar");
    public static final PackagingType TEST_JAR = PackagingType.of("test-jar");
    public static final PackagingType MAVEN_PLUGIN = PackagingType.of("maven-plugin");
    public static final PackagingType EJB = PackagingType.of("ejb");
    public static final PackagingType WAR = PackagingType.of("war");
    public static final PackagingType EAR = PackagingType.of("ear");
    public static final PackagingType RAR = PackagingType.of("rar");
    public static final PackagingType PAR = PackagingType.of("par");
    private final String value;

    private PackagingType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static PackagingType of(String typeName) throws IllegalArgumentException {
        if (typeName == null || typeName.length() == 0) {
            throw new IllegalArgumentException("Packaging type must not be null nor empty.");
        }
        return new PackagingType(typeName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PackagingType other = (PackagingType)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

