/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.gradle.archive.importer.embedded;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.GradleProject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.gradle.archive.importer.embedded.ConfigurationStage;
import org.jboss.shrinkwrap.api.gradle.archive.importer.embedded.DistributionConfigurationStage;
import org.jboss.shrinkwrap.api.gradle.archive.importer.embedded.EmbeddedGradleImporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.impl.base.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedGradleImporterImpl
implements EmbeddedGradleImporter,
DistributionConfigurationStage {
    private final Archive<?> archive;
    private final GradleConnector connector = GradleConnector.newConnector();
    private String[] tasks = new String[]{"build"};
    private String[] arguments = new String[]{"-x", "test"};
    private File projectDir;
    private BuildLauncher buildLauncher;
    private ProjectConnection projectConnection;

    private BuildLauncher getBuildLauncher() {
        if (this.buildLauncher == null) {
            this.projectConnection = this.connector.connect();
            this.buildLauncher = this.projectConnection.newBuild();
        }
        return this.buildLauncher;
    }

    public EmbeddedGradleImporterImpl(Archive<?> archive) {
        this.archive = archive;
    }

    public DistributionConfigurationStage forProjectDirectory(File projectDir) {
        Validate.notNull((Object)projectDir, (String)"Project directory file can not be null!");
        File absoluteFile = projectDir.getAbsoluteFile();
        if (!absoluteFile.isDirectory()) {
            throw new IllegalArgumentException("Give File is not a directory");
        }
        this.projectDir = absoluteFile;
        this.connector.forProjectDirectory(absoluteFile);
        return this;
    }

    public DistributionConfigurationStage forProjectDirectory(String projectDir) {
        Validate.notNull((Object)projectDir, (String)"Project directory path can not be null or empty");
        return this.forProjectDirectory(new File(projectDir));
    }

    public DistributionConfigurationStage forThisProjectDirectory() {
        return this.forProjectDirectory("");
    }

    public <TYPE extends Assignable> TYPE as(Class<TYPE> clazz) {
        final GradleProject gradleProject = (GradleProject)this.projectConnection.getModel(GradleProject.class);
        File buildDir = new File(this.projectDir, "build");
        File libsDir = new File(buildDir, "libs");
        File result = libsDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(gradleProject.getName());
            }
        })[0];
        return (TYPE)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)this.archive.getName())).importFrom(result)).as(clazz);
    }

    public ConfigurationStage useGradleVersion(String version) {
        this.connector.useGradleVersion(version);
        return this;
    }

    public ConfigurationStage useDistribution(URI gradleDistribution) {
        this.connector.useDistribution(gradleDistribution);
        return this;
    }

    public ConfigurationStage useInstallation(File gradleHome) {
        this.connector.useInstallation(gradleHome);
        return this;
    }

    public ConfigurationStage useDefaultDistribution() {
        return this;
    }

    public ConfigurationStage useGradleUserHomeDir(File gradleUserHomeDir) {
        this.connector.useGradleUserHomeDir(gradleUserHomeDir);
        return this;
    }

    public ConfigurationStage forTasks(String ... tasks) {
        this.tasks = tasks;
        return this;
    }

    public ConfigurationStage withArguments(String ... arguments) {
        this.arguments = arguments;
        return this;
    }

    public ConfigurationStage setJavaHome(File javaHome) {
        this.getBuildLauncher().setJavaHome(javaHome);
        return this;
    }

    public ConfigurationStage setJvmArguments(String ... jvmArguments) {
        this.getBuildLauncher().setJvmArguments(jvmArguments);
        return this;
    }

    public Assignable importBuildOutput() {
        this.getBuildLauncher().forTasks(this.tasks).withArguments(this.arguments).run();
        return this;
    }
}

