/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.gradle.archive.importer.embedded;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.gradle.archive.importer.embedded.ConfigurationStage;
import org.jboss.shrinkwrap.api.gradle.archive.importer.embedded.DistributionConfigurationStage;
import org.jboss.shrinkwrap.api.gradle.archive.importer.embedded.EmbeddedGradleImporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.impl.base.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedGradleImporterImpl
implements EmbeddedGradleImporter,
DistributionConfigurationStage {
    private static final String SAX_PARSER_FACTORY_KEY = "javax.xml.parsers.SAXParserFactory";
    private final Archive<?> archive;
    private final GradleConnector connector = GradleConnector.newConnector();
    private String[] tasks = new String[]{"build"};
    private String[] arguments = new String[]{"--exclude-task", "test"};
    private BuildLauncher buildLauncher;
    private ProjectConnection projectConnection;
    private String projectName;
    private File buildResult;

    private BuildLauncher getBuildLauncher() {
        if (this.buildLauncher == null) {
            this.projectConnection = this.connector.connect();
            this.buildLauncher = this.projectConnection.newBuild();
        }
        return this.buildLauncher;
    }

    public EmbeddedGradleImporterImpl(Archive<?> archive) {
        this.archive = archive;
    }

    public DistributionConfigurationStage forProjectDirectory(File projectDir) {
        Validate.notNull((Object)projectDir, (String)"Project directory file can not be null!");
        File absoluteFile = projectDir.getAbsoluteFile();
        if (!absoluteFile.exists()) {
            throw new IllegalArgumentException("Given project dir do not exist: " + absoluteFile);
        }
        if (!absoluteFile.isDirectory()) {
            throw new IllegalArgumentException("Given project dir is not a directory" + absoluteFile);
        }
        this.projectName = absoluteFile.getName();
        this.connector.forProjectDirectory(absoluteFile);
        return this;
    }

    public DistributionConfigurationStage forProjectDirectory(String projectDir) {
        Validate.notNull((Object)projectDir, (String)"Project directory path can not be null or empty");
        return this.forProjectDirectory(new File(projectDir));
    }

    public DistributionConfigurationStage forThisProjectDirectory() {
        return this.forProjectDirectory("");
    }

    public <TYPE extends Assignable> TYPE as(Class<TYPE> clazz) {
        File result = this.buildResult == null ? this.importFromDefaultLibsDirectory() : this.importFromConfiguredPath();
        return (TYPE)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)this.archive.getName())).importFrom(result)).as(clazz);
    }

    private File importFromDefaultLibsDirectory() {
        final GradleProject currentGradleProject = this.findCurrentGradleProject();
        File buildDir = currentGradleProject.getBuildDirectory();
        File libsDir = new File(buildDir, "libs");
        File[] results = libsDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(currentGradleProject.getName());
            }
        });
        if (results == null || results.length == 0) {
            throw new IllegalArgumentException("Wrong project directory is used. Tests have to be run from working directory which is a current sub-module directory.");
        }
        return results[0];
    }

    private File importFromConfiguredPath() {
        return this.buildResult;
    }

    private GradleProject findCurrentGradleProject() {
        GradleProject child;
        GradleProject rootGradleProject = (GradleProject)this.projectConnection.getModel(GradleProject.class);
        if (!rootGradleProject.getName().equals(this.projectName) && (child = this.findChildProject(rootGradleProject, this.projectName)) != null) {
            return child;
        }
        return rootGradleProject;
    }

    private GradleProject findChildProject(GradleProject gradleProject, String childProjectName) {
        DomainObjectSet children = gradleProject.getChildren();
        for (GradleProject child : children) {
            if (!child.getName().equals(childProjectName)) continue;
            return child;
        }
        for (GradleProject child : children) {
            GradleProject foundChild = this.findChildProject(child, childProjectName);
            if (foundChild == null) continue;
            return foundChild;
        }
        return null;
    }

    public ConfigurationStage useGradleVersion(String version) {
        this.connector.useGradleVersion(version);
        return this;
    }

    public ConfigurationStage useDistribution(URI gradleDistribution) {
        this.connector.useDistribution(gradleDistribution);
        return this;
    }

    public ConfigurationStage useInstallation(File gradleHome) {
        this.connector.useInstallation(gradleHome);
        return this;
    }

    public ConfigurationStage useDefaultDistribution() {
        return this;
    }

    public ConfigurationStage useGradleUserHomeDir(File gradleUserHomeDir) {
        this.connector.useGradleUserHomeDir(gradleUserHomeDir);
        return this;
    }

    public ConfigurationStage forTasks(String ... tasks) {
        this.tasks = tasks;
        return this;
    }

    public ConfigurationStage withArguments(String ... arguments) {
        this.arguments = arguments;
        return this;
    }

    public ConfigurationStage setJavaHome(File javaHome) {
        this.getBuildLauncher().setJavaHome(javaHome);
        return this;
    }

    public ConfigurationStage setJvmArguments(String ... jvmArguments) {
        this.getBuildLauncher().setJvmArguments(jvmArguments);
        return this;
    }

    public Assignable importBuildOutput() {
        String oldValue = this.removeSAXParserFactoryProperty();
        ((BuildLauncher)this.getBuildLauncher().forTasks(this.tasks).withArguments(this.arguments)).run();
        this.setSAXParserFactoryProperty(oldValue);
        return this;
    }

    public Assignable importBuildOutput(File buildResult) {
        this.buildResult = buildResult.getAbsoluteFile();
        return this.importBuildOutput();
    }

    public Assignable importBuildOutput(String buildResult) {
        return this.importBuildOutput(new File(buildResult));
    }

    private String removeSAXParserFactoryProperty() {
        Object value = System.getProperties().remove(SAX_PARSER_FACTORY_KEY);
        return value != null ? (String)value : null;
    }

    private void setSAXParserFactoryProperty(String oldValue) {
        if (oldValue != null) {
            System.setProperty(SAX_PARSER_FACTORY_KEY, oldValue);
        }
    }
}

