/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.ConfigurationUtils;

public class CompilerPluginConfiguration {
    private static final String COMPILER_PLUGIN_GA = "org.apache.maven.plugins:maven-compiler-plugin";
    private static final String DEFAULT_RELEASE_VERSION = "1.8";
    private final boolean verbose;
    private final String sourceVersion;
    private final String targetVersion;
    private final String encoding;
    private final String additionalCompilerArgument;
    private final Map<String, String> additionalCompilerArguments;
    private final List<String> additionalCompilerArgs;

    public CompilerPluginConfiguration(ParsedPomFile pomFile) {
        Map rawValues = pomFile.getPluginConfiguration(COMPILER_PLUGIN_GA);
        Properties properties = pomFile.getProperties();
        String releaseVersion = DEFAULT_RELEASE_VERSION;
        String configReleaseVersion = ConfigurationUtils.valueAsString(rawValues, new ConfigurationUtils.Key("release"), properties.getProperty("maven.compiler.release"));
        if (configReleaseVersion != null && !configReleaseVersion.isEmpty()) {
            releaseVersion = configReleaseVersion.equals("8") ? DEFAULT_RELEASE_VERSION : configReleaseVersion;
        }
        this.verbose = ConfigurationUtils.valueAsBoolean(rawValues, new ConfigurationUtils.Key("verbose"), false);
        this.sourceVersion = ConfigurationUtils.valueAsString(rawValues, new ConfigurationUtils.Key("source"), properties.getProperty("maven.compiler.source", releaseVersion));
        this.targetVersion = ConfigurationUtils.valueAsString(rawValues, new ConfigurationUtils.Key("target"), properties.getProperty("maven.compiler.target", releaseVersion));
        this.encoding = ConfigurationUtils.valueAsString(rawValues, new ConfigurationUtils.Key("encoding"), properties.getProperty("project.build.sourceEncoding", ""));
        this.additionalCompilerArguments = CompilerPluginConfiguration.prependKeysWithDash(ConfigurationUtils.valueAsMapOfStrings(rawValues, new ConfigurationUtils.Key("compilerArguments"), Collections.emptyMap()));
        this.additionalCompilerArgs = ConfigurationUtils.valueAsStringList(rawValues, new ConfigurationUtils.Key("compilerArgs", "arg"), Collections.emptyList());
        this.additionalCompilerArgument = ConfigurationUtils.valueAsString(rawValues, new ConfigurationUtils.Key("compilerArgument"), "");
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Map<String, String> getAdditionalCompilerArgs() {
        HashMap<String, String> compilerArgumentsAsMap = new HashMap<String, String>(this.additionalCompilerArguments.size() + this.additionalCompilerArgs.size() + 1);
        if (!this.additionalCompilerArgument.isEmpty()) {
            compilerArgumentsAsMap.put(this.additionalCompilerArgument, null);
        }
        if (!this.additionalCompilerArguments.isEmpty()) {
            compilerArgumentsAsMap.putAll(this.additionalCompilerArguments);
        }
        if (!this.additionalCompilerArgs.isEmpty()) {
            for (String value : this.additionalCompilerArgs) {
                compilerArgumentsAsMap.put(value, null);
            }
        }
        return compilerArgumentsAsMap;
    }

    public CompilerConfiguration asCompilerConfiguration() {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setVerbose(this.isVerbose());
        configuration.setSourceVersion(this.getSourceVersion());
        configuration.setTargetVersion(this.getTargetVersion());
        if (this.encoding != null && !this.encoding.isEmpty()) {
            configuration.setSourceEncoding(this.encoding);
        }
        configuration.setCustomCompilerArgumentsAsMap(this.getAdditionalCompilerArgs());
        configuration.setWorkingDirectory(new File("."));
        return configuration;
    }

    private static Map<String, String> prependKeysWithDash(Map<String, String> original) {
        HashMap<String, String> map = new HashMap<String, String>(original.size());
        for (Map.Entry<String, String> entry : original.entrySet()) {
            map.put("-" + entry.getKey(), entry.getValue());
        }
        return map;
    }
}

