/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.embedded;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.execution.Execution;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.task.archive.UntarTool;
import org.arquillian.spacelift.task.archive.UnzipTool;
import org.arquillian.spacelift.task.net.DownloadTool;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.BuildStage;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.DistributionStage;

public abstract class DistributionStageImpl<NEXT_STEP extends BuildStage>
implements DistributionStage<NEXT_STEP> {
    private String maven3BaseUrl = "https://archive.apache.org/dist/maven/maven-3/%version%/binaries/apache-maven-%version%-bin.tar.gz";
    private File setMavenInstalation = null;
    private String mavenTargetDir = "target" + File.separator + "resolver-maven";
    private Logger log = Logger.getLogger(DistributionStage.class.getName());

    public NEXT_STEP useMaven3Version(String version) {
        try {
            this.useDistribution(new URL(this.maven3BaseUrl.replaceAll("%version%", version)), true);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        return this.returnNextStepType();
    }

    public NEXT_STEP useDistribution(URL mavenDistribution, boolean useCache) {
        File mavenDir = this.prepareMavenDir(useCache);
        File downloaded = this.download(mavenDir, mavenDistribution);
        String downloadedZipMd5hash = this.getMd5hash(downloaded);
        File withExtractedDir = null;
        if (downloadedZipMd5hash != null) {
            withExtractedDir = this.checkIfItIsAlreadyExtracted(downloadedZipMd5hash);
            if (withExtractedDir == null) {
                withExtractedDir = this.extract(downloaded, downloadedZipMd5hash);
            }
            File binDirectory = this.retrieveBinDirectory(withExtractedDir);
            this.useInstallation(binDirectory);
        }
        return this.returnNextStepType();
    }

    private File checkIfItIsAlreadyExtracted(final String downloadedZipMd5hash) {
        File[] dirs = new File(this.mavenTargetDir).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && downloadedZipMd5hash.equals(file.getName());
            }
        });
        if (dirs != null && dirs.length > 0) {
            return dirs[0];
        }
        return null;
    }

    private File retrieveBinDirectory(File uncompressed) {
        File[] extracted = uncompressed.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (extracted.length == 0) {
            throw new IllegalArgumentException("No directory has been extracted from the archive: " + uncompressed);
        }
        if (extracted.length > 1) {
            throw new IllegalArgumentException("More than one directory has been extracted from the archive: " + uncompressed);
        }
        return extracted[0];
    }

    private File extract(File downloaded, String downloadedZipMd5hash) {
        File toExtract;
        block5: {
            toExtract = new File(this.mavenTargetDir + File.separator + downloadedZipMd5hash);
            toExtract.mkdirs();
            String downloadedPath = downloaded.getAbsolutePath();
            try {
                if (downloadedPath.endsWith(".zip")) {
                    ((UnzipTool)Spacelift.task((Object)downloaded, UnzipTool.class)).toDir(toExtract).execute().await();
                    break block5;
                }
                if (downloadedPath.endsWith(".tar.gz")) {
                    ((UntarTool)Spacelift.task((Object)downloaded, UntarTool.class)).gzip(true).toDir(toExtract).execute().await();
                    break block5;
                }
                if (downloadedPath.endsWith(".tar.bz2")) {
                    ((UntarTool)Spacelift.task((Object)downloaded, UntarTool.class)).bzip2(true).toDir(toExtract).execute().await();
                    break block5;
                }
                throw new IllegalArgumentException("The distribution " + downloaded + " is compressed by unsupported format. Supported formats are .zip, .tar.gz, .tar.bz2");
            }
            catch (ExecutionException ee) {
                throw new IllegalStateException("Something bad happened when the file: " + downloadedPath + " was being extracted. For more information see the stacktrace");
            }
        }
        return toExtract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMd5hash(File downloaded) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(downloaded);
            String string = DigestUtils.md5Hex((InputStream)fis);
            return string;
        }
        catch (IOException e) {
            this.log.warning("A problem occurred when md5 hash of a file " + downloaded + " was being retrieved:\n" + e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    this.log.warning("A problem occurred when FileInputStream of a file " + downloaded + "was being closed:\n" + e.getMessage());
                }
            }
        }
        return null;
    }

    private File download(File mavenDir, URL mavenDistribution) {
        String distUrl = mavenDistribution.toString();
        String target = mavenDir + distUrl.substring(distUrl.lastIndexOf("/"));
        File downloaded = null;
        for (File file : mavenDir.listFiles()) {
            if (!file.getAbsolutePath().equals(target)) continue;
            downloaded = file;
        }
        if (downloaded == null) {
            for (int i = 0; i < 3; ++i) {
                try {
                    downloaded = (File)this.runDownloadExecution(mavenDistribution, target).await();
                    break;
                }
                catch (ExecutionException ee) {
                    System.err.print("ERROR: the downloading of Maven binaries has failed. ");
                    if (2 - i <= 0) {
                        System.err.println("For more information see the stacktrace of an exception");
                        throw ee;
                    }
                    System.err.println("Trying again - number of remaining attempts: " + (2 - i));
                    continue;
                }
            }
        }
        return downloaded;
    }

    private Execution<File> runDownloadExecution(URL mavenDistribution, String target) {
        Execution execution = ((DownloadTool)Spacelift.task(DownloadTool.class)).from(mavenDistribution).to(target).execute();
        System.out.println("Resolver: downloading Maven binaries from " + mavenDistribution + " to " + target);
        while (!execution.isFinished()) {
            System.out.print(".");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.log.warning("Problem occurred when the thread was sleeping:\n" + e.getMessage());
            }
        }
        System.out.println();
        return execution;
    }

    private File prepareMavenDir(boolean useCache) {
        String dirPath = useCache ? System.getProperty("user.home") + File.separator + ".arquillian" + File.separator + "resolver" + File.separator + "maven" : this.mavenTargetDir + File.separator + "downloaded" + File.separator;
        File mavenDir = new File(dirPath);
        if (!mavenDir.exists()) {
            mavenDir.mkdirs();
        }
        return mavenDir;
    }

    public NEXT_STEP useInstallation(File mavenHome) {
        this.setMavenInstalation = mavenHome;
        return this.returnNextStepType();
    }

    public NEXT_STEP useDefaultDistribution() {
        return this.returnNextStepType();
    }

    protected File getSetMavenInstalation() {
        return this.setMavenInstalation;
    }

    protected abstract NEXT_STEP returnNextStepType();
}

