/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.embedded;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.BuildStage;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.DistributionStage;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.daemon.DaemonBuildTrigger;
import org.jboss.shrinkwrap.resolver.impl.maven.embedded.BinaryDownloader;
import org.jboss.shrinkwrap.resolver.impl.maven.embedded.FileExtractor;

public abstract class DistributionStageImpl<NEXT_STEP extends BuildStage<DAEMON_TRIGGER_TYPE>, DAEMON_TRIGGER_TYPE extends DaemonBuildTrigger>
implements DistributionStage<NEXT_STEP, DAEMON_TRIGGER_TYPE> {
    private static final String MAVEN_3_BASE_URL = "https://archive.apache.org/dist/maven/maven-3/%version%/binaries/apache-maven-%version%-bin.tar.gz";
    public static final String MAVEN_TARGET_DIR = "target" + File.separator + "resolver-maven";
    public static final String MAVEN_CACHE_DIR = System.getProperty("user.home") + File.separator + ".arquillian" + File.separator + "resolver" + File.separator + "maven";
    private File setMavenInstallation = null;
    private boolean useLocalInstallation = false;
    private Logger log = Logger.getLogger(DistributionStage.class.getName());

    public NEXT_STEP useMaven3Version(String version) {
        try {
            this.useDistribution(new URL(MAVEN_3_BASE_URL.replaceAll("%version%", version)), true);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        return this.returnNextStepType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NEXT_STEP useDistribution(URL mavenDistribution, boolean useCache) {
        String string = MAVEN_3_BASE_URL;
        synchronized (MAVEN_3_BASE_URL) {
            File mavenDir = this.prepareMavenDir(useCache);
            File downloaded = BinaryDownloader.download(mavenDir, mavenDistribution);
            String downloadedZipMd5hash = this.getMd5hash(downloaded);
            if (downloadedZipMd5hash != null) {
                File withExtractedDir = FileExtractor.extract(downloaded, Paths.get(MAVEN_TARGET_DIR, downloadedZipMd5hash).toFile());
                File binDirectory = this.retrieveBinDirectory(withExtractedDir);
                this.useInstallation(binDirectory);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.returnNextStepType();
        }
    }

    private File retrieveBinDirectory(File uncompressed) {
        File[] extracted = uncompressed.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (extracted.length == 0) {
            throw new IllegalArgumentException("No directory has been extracted from the archive: " + uncompressed);
        }
        if (extracted.length > 1) {
            throw new IllegalArgumentException("More than one directory has been extracted from the archive: " + uncompressed);
        }
        return extracted[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMd5hash(File downloaded) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(downloaded);
            String string = DigestUtils.md5Hex((InputStream)fis);
            return string;
        }
        catch (IOException e) {
            this.log.warning("A problem occurred when md5 hash of a file " + downloaded + " was being retrieved:\n" + e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    this.log.warning("A problem occurred when FileInputStream of a file " + downloaded + "was being closed:\n" + e.getMessage());
                }
            }
        }
        return null;
    }

    private File prepareMavenDir(boolean useCache) {
        String dirPath = useCache ? MAVEN_CACHE_DIR : MAVEN_TARGET_DIR + File.separator + "downloaded" + File.separator;
        File mavenDir = new File(dirPath);
        if (!mavenDir.exists()) {
            mavenDir.mkdirs();
        }
        return mavenDir;
    }

    public NEXT_STEP useInstallation(File mavenHome) {
        this.setMavenInstallation = mavenHome;
        return this.returnNextStepType();
    }

    public NEXT_STEP useDefaultDistribution() {
        this.useMaven3Version("3.5.2");
        return this.returnNextStepType();
    }

    public NEXT_STEP useLocalInstallation() {
        this.useLocalInstallation = true;
        return this.returnNextStepType();
    }

    protected File getSetMavenInstallation() {
        return this.setMavenInstallation;
    }

    protected boolean shouldUseLocalInstallation() {
        return this.useLocalInstallation;
    }

    protected abstract NEXT_STEP returnNextStepType();
}

