/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.embedded.pom.equipped;

import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

public abstract class AbstractOutputHandler
implements InvocationOutputHandler {
    private final StringBuffer logBuffer;
    private Pattern expectedPattern;
    private CountDownLatch countDownLatch;
    private boolean quiet = false;

    public AbstractOutputHandler(StringBuffer logBuffer, String expectedRegex, CountDownLatch countDownLatch) {
        this.logBuffer = logBuffer;
        if (expectedRegex != null) {
            this.expectedPattern = Pattern.compile(expectedRegex);
            this.countDownLatch = countDownLatch;
        }
    }

    public AbstractOutputHandler(StringBuffer logBuffer) {
        this.logBuffer = logBuffer;
    }

    public void consumeLine(String line) {
        if (!this.quiet) {
            this.printLine("-> " + line);
        }
        if (this.expectedPattern == null) {
            this.logBuffer.append(line).append("\n");
        } else if (this.countDownLatch != null && this.countDownLatch.getCount() > 0L && !Validate.isNullOrEmpty((String)line) && line.matches(this.expectedPattern.toString())) {
            this.countDownLatch.countDown();
        }
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    protected abstract void printLine(String var1);
}

