/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.embedded;

import java.io.File;
import org.jboss.shrinkwrap.resolver.impl.maven.embedded.FilePermission;

public class PermissionsUtil {
    private static final int OWNER_READ_FLAG = 256;
    private static final int OWNER_WRITE_FLAG = 128;
    private static final int OWNER_EXECUTE_FLAG = 64;
    private static final int GROUP_READ_FLAG = 32;
    private static final int GROUP_WRITE_FLAG = 16;
    private static final int GROUP_EXECUTE_FLAG = 8;
    private static final int OTHERS_READ_FLAG = 4;
    private static final int OTHERS_WRITE_FLAG = 2;
    private static final int OTHERS_EXECUTE_FLAG = 1;

    public static FilePermission toFilePermission(int mode) {
        int maskedMode = mode & 0x1FF;
        FilePermission filePermission = new FilePermission();
        if ((maskedMode & 0x100) > 0) {
            filePermission.setOwnerCanRead(true);
        }
        if ((maskedMode & 0x80) > 0) {
            filePermission.setOwnerCanWrite(true);
        }
        if ((maskedMode & 0x40) > 0) {
            filePermission.setOwnerCanExecute(true);
        }
        if ((maskedMode & 0x20) > 0) {
            filePermission.setGroupCanRead(true);
        }
        if ((maskedMode & 0x10) > 0) {
            filePermission.setGroupCanWrite(true);
        }
        if ((maskedMode & 8) > 0) {
            filePermission.setGroupCanExecute(true);
        }
        if ((maskedMode & 4) > 0) {
            filePermission.setOthersCanRead(true);
        }
        if ((maskedMode & 2) > 0) {
            filePermission.setOthersCanWrite(true);
        }
        if ((maskedMode & 1) > 0) {
            filePermission.setOthersCanExecute(true);
        }
        return filePermission;
    }

    public static void applyPermission(File file, FilePermission permissions) {
        boolean executableSet = file.setExecutable(permissions.isOwnerCanExecute(), !permissions.isGroupCanExecute() && !permissions.isOthersCanExecute());
        boolean writableSet = file.setWritable(permissions.isOwnerCanWrite(), !permissions.isGroupCanWrite() && !permissions.isOthersCanWrite());
        boolean readableSet = file.setReadable(permissions.isOwnerCanRead(), !permissions.isGroupCanRead() && !permissions.isOthersCanRead());
        if (!(executableSet && writableSet && readableSet)) {
            System.err.println("Unable to change permissions of extracted files.");
        }
    }
}

