/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.maven.model.Model;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;
import org.jboss.shrinkwrap.resolver.api.maven.MavenImporter;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.maven.filter.CombinedFilter;
import org.jboss.shrinkwrap.resolver.api.maven.filter.ScopeFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenBuilderImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyResolverSettings;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenPackagingType;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenRepositorySystem;
import org.sonatype.aether.RepositorySystemSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EffectivePomMavenImporterImpl
implements MavenImporter.EffectivePomMavenImporter {
    private Archive<?> archive;
    private final MavenPackagingType mpt;
    private final Model model;
    private Stack<MavenDependency> dependencies;
    private final MavenRepositorySystem system;
    private final MavenDependencyResolverSettings settings;
    private RepositorySystemSession session;

    public EffectivePomMavenImporterImpl(Archive<?> archive, MavenPackagingType mpt, Model model, MavenRepositorySystem system, MavenDependencyResolverSettings settings, RepositorySystemSession session) {
        this.archive = archive;
        this.mpt = mpt;
        this.model = model;
        this.system = system;
        this.settings = settings;
        this.session = session;
        this.dependencies = MavenConverter.fromDependencies(model.getDependencies(), system.getArtifactTypeRegistry(session));
    }

    public <TYPE extends Assignable> TYPE as(Class<TYPE> archiveType) {
        return (TYPE)this.archive.as(archiveType);
    }

    public MavenImporter.EffectivePomMavenImporter importBuildOutput() {
        this.archive = this.mpt.enrichArchiveWithBuildOutput(this.archive, this.model);
        return this;
    }

    public MavenImporter.EffectivePomMavenImporter importTestBuildOutput() {
        this.archive = this.mpt.enrichArchiveWithTestOutput(this.archive, this.model);
        return this;
    }

    public MavenImporter.EffectivePomMavenImporter importTestDependencies() {
        return this.importAnyDependencies((MavenResolutionFilter)new ScopeFilter(new String[]{"test"}));
    }

    public MavenImporter.EffectivePomMavenImporter importAnyDependencies(MavenResolutionFilter filter) {
        MavenDependencyResolver resolver = this.getMavenDependencyResolver(this.dependencies, new HashSet<MavenDependency>());
        this.archive = this.mpt.enrichArchiveWithTestArtifacts(this.archive, resolver, filter);
        return this;
    }

    public MavenImporter.EffectivePomMavenImporter importTestDependencies(MavenResolutionFilter filter) throws IllegalArgumentException {
        if (filter == null) {
            throw new IllegalArgumentException("At least one filter must be defined");
        }
        return this.importAnyDependencies((MavenResolutionFilter)new CombinedFilter(new MavenResolutionFilter[]{new ScopeFilter(new String[]{"test"}), filter}));
    }

    private MavenDependencyResolver getMavenDependencyResolver(Stack<MavenDependency> dependencies, Set<MavenDependency> versionManagement) {
        return new MavenBuilderImpl(this.system, this.session, this.settings, dependencies, versionManagement);
    }
}

