/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.maven.model.Model;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolverShortcutAPI;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.maven.filter.StrictFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenBuilderImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyResolverSettings;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyResolverShortcutAPIInternal;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenRepositorySystem;
import org.jboss.shrinkwrap.resolver.impl.maven.util.ResourceUtil;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenImpl
implements Maven.MavenShortcutAPI,
MavenDependencyResolverShortcutAPIInternal {
    private final MavenRepositorySystem system;
    private final MavenDependencyResolverSettings settings;
    private RepositorySystemSession session;
    private Stack<MavenDependency> dependencies;
    private Set<MavenDependency> versionManagement;

    public MavenImpl() {
        this.system = new MavenRepositorySystem();
        this.settings = new MavenDependencyResolverSettings();
        this.dependencies = new Stack();
        this.versionManagement = new HashSet<MavenDependency>();
        this.session = this.system.getSession(this.settings);
    }

    public MavenImpl(MavenRepositorySystem system, RepositorySystemSession session, MavenDependencyResolverSettings settings, Stack<MavenDependency> dependencies, Set<MavenDependency> dependencyManagement) {
        this.system = system;
        this.session = session;
        this.settings = settings;
        this.dependencies = dependencies;
        this.versionManagement = dependencyManagement;
    }

    public GenericArchive dependency(String coordinates) throws ResolutionException {
        return (GenericArchive)this.artifact(coordinates).resolveArtifactAs(GenericArchive.class);
    }

    public Collection<GenericArchive> dependencies(String ... coordinates) throws ResolutionException {
        return this.artifacts(coordinates).resolveArtifactsAs(GenericArchive.class);
    }

    public Maven.MavenShortcutAPI withPom(String path) throws ResolutionException {
        String resolvedPath = ResourceUtil.resolvePathByQualifier(path);
        Validate.isReadable(resolvedPath, "Path to the pom.xml ('" + path + "')file must be defined and accessible");
        File pom = new File(resolvedPath);
        Model model = this.system.loadPom(pom, this.settings, this.session);
        ArtifactTypeRegistry stereotypes = this.system.getArtifactTypeRegistry(this.session);
        Stack<MavenDependency> pomDefinedDependencies = MavenConverter.fromDependencies(model.getDependencies(), stereotypes);
        this.versionManagement.addAll(pomDefinedDependencies);
        return this;
    }

    public MavenDependencyResolverShortcutAPI artifact(String coordinates) throws ResolutionException {
        Validate.notNullOrEmpty(coordinates, "Artifact coordinates must not be null or empty");
        return new MavenResolver((MavenDependencyResolverShortcutAPIInternal)this, coordinates);
    }

    public MavenDependencyResolverShortcutAPI artifacts(String ... coordinates) throws ResolutionException {
        Validate.notNullAndNoNullValues(coordinates, "Artifacts coordinates must not be null or empty");
        return new MavenResolver((MavenDependencyResolverShortcutAPIInternal)this, coordinates);
    }

    public <ARCHIVEVIEW extends Assignable> ARCHIVEVIEW resolveArtifactAs(Class<ARCHIVEVIEW> archiveView) throws ResolutionException {
        Collection<ARCHIVEVIEW> archiveViews = new MavenBuilderImpl(this.system, this.session, this.settings, this.dependencies, this.versionManagement).resolveAs(archiveView, (MavenResolutionFilter)new StrictFilter());
        if (archiveViews != null && archiveViews.size() != 1) {
            throw new ResolutionException("Only one artifact should have been resolved. Resolved " + archiveViews.size() + " artifacts.");
        }
        return (ARCHIVEVIEW)(archiveViews == null ? null : (Assignable)archiveViews.iterator().next());
    }

    public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveArtifactsAs(Class<ARCHIVEVIEW> archiveView) throws ResolutionException {
        return new MavenBuilderImpl(this.system, this.session, this.settings, this.dependencies, this.versionManagement).resolveAs(archiveView, (MavenResolutionFilter)new StrictFilter());
    }

    @Override
    public Stack<MavenDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Set<MavenDependency> getVersionManagement() {
        return this.versionManagement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MavenResolver
    implements MavenDependencyResolverShortcutAPIInternal {
        private final MavenDependencyResolverShortcutAPIInternal delegate;

        MavenResolver(MavenDependencyResolverShortcutAPIInternal delegate, String coordinates) throws ResolutionException {
            assert (delegate != null) : "Delegate must be specified";
            this.delegate = delegate;
            MavenDependency dependency = MavenConverter.asDepedencyWithVersionManagement(delegate.getVersionManagement(), coordinates);
            delegate.getDependencies().push(dependency);
        }

        MavenResolver(MavenDependencyResolverShortcutAPIInternal delegate, String ... coordinates) {
            assert (delegate != null) : "Delegate must be specified";
            this.delegate = delegate;
            for (String coords : coordinates) {
                MavenDependency dependency = MavenConverter.asDepedencyWithVersionManagement(delegate.getVersionManagement(), coords);
                delegate.getDependencies().push(dependency);
            }
        }

        public Maven.MavenShortcutAPI withPom(String path) {
            return this.delegate.withPom(path);
        }

        public MavenDependencyResolverShortcutAPI artifact(String coordinates) throws ResolutionException {
            return (MavenDependencyResolverShortcutAPI)this.delegate.artifact(coordinates);
        }

        public MavenDependencyResolverShortcutAPI artifacts(String ... coordinates) throws ResolutionException {
            return (MavenDependencyResolverShortcutAPI)this.delegate.artifacts(coordinates);
        }

        public <ARCHIVEVIEW extends Assignable> ARCHIVEVIEW resolveArtifactAs(Class<ARCHIVEVIEW> archiveView) throws ResolutionException {
            return (ARCHIVEVIEW)this.delegate.resolveArtifactAs(archiveView);
        }

        public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveArtifactsAs(Class<ARCHIVEVIEW> archiveView) throws ResolutionException {
            return this.delegate.resolveArtifactsAs(archiveView);
        }

        @Override
        public Stack<MavenDependency> getDependencies() {
            return this.delegate.getDependencies();
        }

        @Override
        public Set<MavenDependency> getVersionManagement() {
            return this.delegate.getVersionManagement();
        }
    }
}

