/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import org.apache.maven.model.Model;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.DependencyResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum MavenPackagingType {
    JAR{

        @Override
        public Archive<?> enrichArchiveWithBuildOutput(Archive<?> original, Model model) {
            return (Archive)((ExplodedImporter)original.as(ExplodedImporter.class)).importDirectory(this.getClassesDirectory(model)).as(JavaArchive.class);
        }

        @Override
        public Archive<?> enrichArchiveWithTestArtifacts(Archive<?> original, MavenDependencyResolver resolver, MavenResolutionFilter filter) {
            throw new UnsupportedOperationException("Enable to enrich archive " + original.getName() + " by test dependencies, this operation is not supported for packagings of type <packaging>jar</packaging>");
        }

        @Override
        public Archive<?> enrichArchiveWithTestOutput(Archive<?> original, Model model) {
            return (Archive)((ExplodedImporter)original.as(ExplodedImporter.class)).importDirectory(this.getTestClassesDirectory(model)).as(JavaArchive.class);
        }

        private File getClassesDirectory(Model model) {
            String buildOutputDirectory = model.getBuild().getOutputDirectory();
            Validate.isReadable(buildOutputDirectory, "Cannot include compiled classes from " + buildOutputDirectory + ", directory cannot be read.");
            return new File(buildOutputDirectory);
        }

        private File getTestClassesDirectory(Model model) {
            String buildTestOutputDirectory = model.getBuild().getTestOutputDirectory();
            Validate.isReadable(buildTestOutputDirectory, "Cannot include compiled test classes from " + buildTestOutputDirectory + ", directory cannot be read. Please make sure you're running in integration-test phase.");
            return new File(buildTestOutputDirectory);
        }
    }
    ,
    WAR{

        @Override
        public Archive<?> enrichArchiveWithBuildOutput(Archive<?> original, Model model) {
            return (Archive)((ExplodedImporter)original.as(ExplodedImporter.class)).importDirectory(this.getWebappDirectory(model)).as(WebArchive.class);
        }

        @Override
        public Archive<?> enrichArchiveWithTestArtifacts(Archive<?> original, MavenDependencyResolver resolver, MavenResolutionFilter filter) {
            WebArchive war = (WebArchive)original.as(WebArchive.class);
            war.addAsLibraries(resolver.resolveAsFiles((DependencyResolutionFilter)filter));
            return war;
        }

        @Override
        public Archive<?> enrichArchiveWithTestOutput(Archive<?> original, Model model) {
            JavaArchive testClasses = (JavaArchive)((ExplodedImporter)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test-classes.jar")).as(ExplodedImporter.class)).importDirectory(this.getTestClassesDirectory(model)).as(JavaArchive.class);
            return (Archive)original.merge((Archive)testClasses, "WEB-INF/classes").as(WebArchive.class);
        }

        private File getWebappDirectory(Model model) {
            String buildDirectory = model.getBuild().getDirectory();
            String finalName = model.getBuild().getFinalName();
            String path = buildDirectory + File.separator + finalName;
            Validate.isReadable(path, "Cannot include exploded war archive from " + path + ", directory cannot be read. Please make sure you're running in integration-test phase.");
            return new File(path);
        }

        private File getTestClassesDirectory(Model model) {
            String buildTestOutputDirectory = model.getBuild().getTestOutputDirectory();
            Validate.isReadable(buildTestOutputDirectory, "Cannot include compiled test classes from " + buildTestOutputDirectory + ", directory cannot be read.");
            return new File(buildTestOutputDirectory);
        }
    }
    ,
    EAR{

        @Override
        public Archive<?> enrichArchiveWithBuildOutput(Archive<?> original, Model model) {
            return (Archive)((ExplodedImporter)original.as(ExplodedImporter.class)).importDirectory(this.getWorkDirectory(model)).as(EnterpriseArchive.class);
        }

        @Override
        public Archive<?> enrichArchiveWithTestArtifacts(Archive<?> original, MavenDependencyResolver resolver, MavenResolutionFilter filter) {
            EnterpriseArchive ear = (EnterpriseArchive)original.as(EnterpriseArchive.class);
            ear.addAsLibraries(resolver.resolveAsFiles((DependencyResolutionFilter)filter));
            return ear;
        }

        @Override
        public Archive<?> enrichArchiveWithTestOutput(Archive<?> original, Model model) {
            throw new UnsupportedOperationException("Enable to enrich archive " + original.getName() + " by test classes output, this operation is not supported for packagings of type <packaging>ear</packaging>.\n" + "If you want to include the test classes, you have to include the classes in a jar file and add it as library into EAR.");
        }

        private File getWorkDirectory(Model model) {
            String buildDirectory = model.getBuild().getDirectory();
            String finalName = model.getBuild().getFinalName();
            String path = buildDirectory + File.separator + finalName;
            Validate.isReadable(path, "Cannot include exploded ear archive from " + path + ", directory cannot be read. Please make sure you're running in integration-test phase.");
            return new File(path);
        }
    };


    public abstract Archive<?> enrichArchiveWithBuildOutput(Archive<?> var1, Model var2);

    public abstract Archive<?> enrichArchiveWithTestArtifacts(Archive<?> var1, MavenDependencyResolver var2, MavenResolutionFilter var3);

    public abstract Archive<?> enrichArchiveWithTestOutput(Archive<?> var1, Model var2);

    public static MavenPackagingType from(String mavenType) {
        Validate.notNullOrEmpty(mavenType, "Maven packaging type must not be empty");
        try {
            return Enum.valueOf(MavenPackagingType.class, mavenType.trim().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            StringBuilder sb = new StringBuilder("Unable to create MavenPackagingType, supported packagings are: ");
            for (MavenPackagingType mpt : MavenPackagingType.values()) {
                sb.append(mpt.toString().toLowerCase()).append(" ");
            }
            throw new IllegalArgumentException(sb.toString(), e);
        }
    }
}

