/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.jboss.shrinkwrap.resolver.impl.maven.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenSettingsBuilder {
    private static Logger log = Logger.getLogger(MavenSettingsBuilder.class.getName());
    public static final String ALT_USER_SETTINGS_XML_LOCATION = "org.apache.maven.user-settings";
    public static final String ALT_GLOBAL_SETTINGS_XML_LOCATION = "org.apache.maven.global-settings";
    public static final String ALT_MAVEN_OFFLINE = "org.apache.maven.offline";
    public static final String ALT_LOCAL_REPOSITORY_LOCATION = "maven.repo.local";
    private static final String DEFAULT_USER_SETTINGS_PATH = SecurityActions.getProperty("user.home").concat("/.m2/settings.xml");
    private static final String DEFAULT_REPOSITORY_PATH = SecurityActions.getProperty("user.home").concat("/.m2/repository");

    public Settings buildDefaultSettings() {
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        String altUserSettings = SecurityActions.getProperty(ALT_USER_SETTINGS_XML_LOCATION);
        String altGlobalSettings = SecurityActions.getProperty(ALT_GLOBAL_SETTINGS_XML_LOCATION);
        request.setUserSettingsFile(new File(DEFAULT_USER_SETTINGS_PATH));
        if (altUserSettings != null && altUserSettings.length() > 0) {
            request.setUserSettingsFile(new File(altUserSettings));
        }
        if (altGlobalSettings != null && altGlobalSettings.length() > 0) {
            request.setGlobalSettingsFile(new File(altGlobalSettings));
        }
        return this.buildSettings((SettingsBuildingRequest)request);
    }

    public Settings buildSettings(SettingsBuildingRequest request) {
        SettingsBuildingResult result;
        try {
            DefaultSettingsBuilder builder = new DefaultSettingsBuilderFactory().newInstance();
            if (log.isLoggable(Level.FINE)) {
                if (request.getGlobalSettingsFile() != null) {
                    log.fine("Using " + request.getGlobalSettingsFile().getAbsolutePath() + " to get global Maven settings.xml");
                }
                if (request.getUserSettingsFile() != null) {
                    log.fine("Using " + request.getUserSettingsFile().getAbsolutePath() + " to get user Maven settings.xml");
                }
            }
            result = builder.build(request);
            this.logSettingsProblems(result.getProblems());
        }
        catch (SettingsBuildingException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to parse Maven configuration", e);
        }
        Settings settings = result.getEffectiveSettings();
        if (settings.getLocalRepository() == null) {
            settings = this.enrichWithLocalRepository(settings);
        }
        return this.enrichWithOfflineMode(settings);
    }

    private Settings enrichWithLocalRepository(Settings settings) {
        String altLocalRepository = SecurityActions.getProperty(ALT_LOCAL_REPOSITORY_LOCATION);
        settings.setLocalRepository(DEFAULT_REPOSITORY_PATH);
        if (altLocalRepository != null && altLocalRepository.length() > 0) {
            settings.setLocalRepository(altLocalRepository);
        }
        return settings;
    }

    private Settings enrichWithOfflineMode(Settings settings) {
        String goOffline = SecurityActions.getProperty(ALT_MAVEN_OFFLINE);
        if (goOffline != null) {
            settings.setOffline(Boolean.valueOf(goOffline).booleanValue());
        }
        return settings;
    }

    private void logSettingsProblems(List<SettingsProblem> problems) {
        if (!log.isLoggable(Level.WARNING)) {
            return;
        }
        for (SettingsProblem problem : problems) {
            StringBuilder sb = new StringBuilder();
            sb.append(problem.getMessage()).append("@").append(problem.getLocation());
            log.warning(sb.toString());
        }
    }
}

