/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.impl.maven.SecurityActions;
import org.jboss.shrinkwrap.resolver.impl.maven.aether.ClasspathWorkspaceReader;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.MavenRepositorySystem;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.MavenSettingsBuilder;
import org.jboss.shrinkwrap.resolver.impl.maven.convert.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.internal.MavenModelResolver;
import org.jboss.shrinkwrap.resolver.impl.maven.internal.SettingsXmlProfileSelector;
import org.jboss.shrinkwrap.resolver.impl.maven.logging.LogModelProblemCollector;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.repository.DefaultMirrorSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenWorkingSessionImpl
implements MavenWorkingSession {
    private final Set<MavenDependency> dependencyManagement;
    private final List<MavenDependency> dependencies;
    private final Set<MavenDependency> declaredDependencies;
    private static final Logger log = Logger.getLogger(MavenWorkingSessionImpl.class.getName());
    private static final String MAVEN_CENTRAL_NAME = "central";
    private static final RemoteRepository MAVEN_CENTRAL = new RemoteRepository("central", "default", "http://repo1.maven.org/maven2");
    private final MavenRepositorySystem system = new MavenRepositorySystem();
    private Settings settings = new MavenSettingsBuilder().buildDefaultSettings();
    private RepositorySystemSession session;
    private Model model;
    private final List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
    private boolean useMavenCentralRepository = true;

    public MavenWorkingSessionImpl() {
        this.session = this.system.getSession(this.settings);
        this.dependencies = new ArrayList<MavenDependency>();
        this.dependencyManagement = new HashSet<MavenDependency>();
        this.declaredDependencies = new HashSet<MavenDependency>();
        ((MavenRepositorySystemSession)this.session).setWorkspaceReader((WorkspaceReader)new ClasspathWorkspaceReader());
    }

    @Override
    public Set<MavenDependency> getDependencyManagement() {
        return this.dependencyManagement;
    }

    @Override
    public List<MavenDependency> getDependenciesForResolution() {
        return this.dependencies;
    }

    @Override
    public Set<MavenDependency> getDeclaredDependencies() {
        return this.declaredDependencies;
    }

    @Override
    public MavenWorkingSession execute(ModelBuildingRequest request) throws InvalidConfigurationFileException {
        Model model;
        ModelBuildingResult result;
        DefaultModelBuilder builder = new DefaultModelBuilderFactory().newInstance();
        try {
            request.setModelResolver((ModelResolver)new MavenModelResolver(this.system, this.session, this.getRemoteRepositories()));
            result = builder.build(request);
        }
        catch (ModelBuildingException e) {
            String pomPath = request.getPomFile().getAbsolutePath();
            StringBuilder sb = new StringBuilder("Found ").append(e.getProblems().size()).append(" problems while building POM model from ").append(pomPath).append("\n");
            int counter = 1;
            for (ModelProblem problem : e.getProblems()) {
                sb.append(counter++).append("/ ").append(problem).append("\n");
            }
            throw new InvalidConfigurationFileException(sb.toString());
        }
        this.model = model = result.getEffectiveModel();
        for (Repository repository : model.getRepositories()) {
            this.remoteRepositories.add(MavenConverter.asRemoteRepository(repository));
        }
        return this;
    }

    @Override
    public MavenWorkingSession execute(SettingsBuildingRequest request) throws InvalidConfigurationFileException {
        MavenSettingsBuilder builder = new MavenSettingsBuilder();
        this.settings = builder.buildSettings(request);
        return this.goOffline(this.settings.isOffline());
    }

    @Override
    public Collection<ArtifactResult> execute(CollectRequest request, MavenResolutionFilter[] filters) throws DependencyResolutionException {
        return this.system.resolveDependencies(this.session, this, request, filters);
    }

    public MavenWorkingSession goOffline(boolean value) {
        String goOffline = SecurityActions.getProperty("org.apache.maven.offline");
        if (goOffline != null) {
            this.settings.setOffline(Boolean.valueOf(goOffline).booleanValue());
            log.log(Level.FINE, "Offline settings is set via a system property. The new offline flag value is: {0}", this.settings.isOffline());
        } else {
            this.settings.setOffline(value);
        }
        return this;
    }

    @Override
    public List<RemoteRepository> getRemoteRepositories() throws IllegalStateException {
        if (this.settings.isOffline()) {
            log.log(Level.WARNING, "No remote repositories will be available, working in offline mode");
            return Collections.emptyList();
        }
        LinkedHashSet<RemoteRepository> enhancedRepos = new LinkedHashSet<RemoteRepository>();
        SettingsXmlProfileSelector selector = new SettingsXmlProfileSelector();
        LogModelProblemCollector problems = new LogModelProblemCollector();
        List activeProfiles = selector.getActiveProfiles(MavenConverter.asProfiles(this.settings.getProfiles()), new ProfileActivationContext(){

            public Map<String, String> getUserProperties() {
                return Collections.emptyMap();
            }

            public Map<String, String> getSystemProperties() {
                return new HashMap<Object, Object>(SecurityActions.getProperties());
            }

            public File getProjectDirectory() {
                return new File(SecurityActions.getProperty("user.dir"));
            }

            public List<String> getInactiveProfileIds() {
                return Collections.emptyList();
            }

            public List<String> getActiveProfileIds() {
                return MavenWorkingSessionImpl.this.settings.getActiveProfiles();
            }
        }, problems);
        if (problems.hasSevereFailures()) {
            throw new IllegalStateException("Unable to get active profiles from Maven settings.");
        }
        for (Profile p : activeProfiles) {
            for (Repository repository : p.getRepositories()) {
                enhancedRepos.add(MavenConverter.asRemoteRepository(repository));
            }
        }
        enhancedRepos.addAll(this.remoteRepositories);
        if (this.useMavenCentralRepository) {
            enhancedRepos.add(MAVEN_CENTRAL);
        } else {
            RemoteRepository repoToRemove = null;
            for (RemoteRepository repo : enhancedRepos) {
                String string = repo.getUrl();
                if (!string.contains("maven.org") && !string.contains("apache.org") || !repo.getId().equalsIgnoreCase(MAVEN_CENTRAL_NAME)) continue;
                repoToRemove = repo;
            }
            if (repoToRemove != null) {
                enhancedRepos.remove(repoToRemove);
            }
        }
        DefaultMirrorSelector dms = new DefaultMirrorSelector();
        for (Mirror mirror : this.settings.getMirrors()) {
            dms.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        LinkedHashSet<RemoteRepository> mirroredRepos = new LinkedHashSet<RemoteRepository>();
        for (RemoteRepository remoteRepository : enhancedRepos) {
            RemoteRepository mirror = dms.getMirror(remoteRepository);
            if (mirror != null) {
                mirroredRepos.add(mirror);
                continue;
            }
            mirroredRepos.add(remoteRepository);
        }
        for (RemoteRepository remoteRepository : mirroredRepos) {
            Server server = this.settings.getServer(remoteRepository.getId());
            if (server == null) continue;
            Authentication authentication = new Authentication(server.getUsername(), server.getPassword(), server.getPrivateKey(), server.getPassphrase());
            remoteRepository.setAuthentication(authentication);
        }
        if (log.isLoggable(Level.FINER)) {
            for (RemoteRepository remoteRepository : mirroredRepos) {
                log.finer("Repository " + remoteRepository.getUrl() + " have been made available for artifact resolution");
            }
        }
        return new ArrayList<RemoteRepository>(mirroredRepos);
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public MavenWorkingSession regenerateSession() {
        this.session = this.system.getSession(this.settings);
        return this;
    }

    @Override
    public List<Profile> getSettingsDefinedProfiles() {
        return MavenConverter.asProfiles(this.settings.getProfiles());
    }

    @Override
    public ArtifactTypeRegistry getArtifactTypeRegistry() {
        return this.session.getArtifactTypeRegistry();
    }

    @Override
    public void setOffline(boolean offline) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Set offline mode to: " + offline);
        }
        this.settings.setOffline(offline);
    }

    @Override
    public void disableClassPathWorkspaceReader() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Disabling ClassPath resolution");
        }
        ((MavenRepositorySystemSession)this.session).setWorkspaceReader(null);
    }

    @Override
    public void disableMavenCentral() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Disabling Maven Central");
        }
        this.useMavenCentralRepository = false;
    }
}

