/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.resolver.api.NoResolvedResultException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStageBase;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.NonTransitiveStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.TransitiveStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSessionContainer;
import org.jboss.shrinkwrap.resolver.impl.maven.convert.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.DependencyResolutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MavenStrategyStageBaseImpl<STRATEGYSTAGETYPE extends MavenStrategyStageBase<STRATEGYSTAGETYPE, FORMATSTAGETYPE>, FORMATSTAGETYPE extends MavenFormatStage>
implements MavenStrategyStageBase<STRATEGYSTAGETYPE, FORMATSTAGETYPE>,
MavenWorkingSessionContainer {
    private static final Logger log = Logger.getLogger(MavenStrategyStageBaseImpl.class.getName());
    private final MavenWorkingSession session;

    public MavenStrategyStageBaseImpl(MavenWorkingSession session) {
        this.session = session;
    }

    public FORMATSTAGETYPE withTransitivity() {
        return this.using((MavenResolutionStrategy)TransitiveStrategy.INSTANCE);
    }

    public FORMATSTAGETYPE withoutTransitivity() {
        return this.using((MavenResolutionStrategy)NonTransitiveStrategy.INSTANCE);
    }

    @Override
    public MavenWorkingSession getMavenWorkingSession() {
        return this.session;
    }

    private List<MavenDependency> preFilter(MavenResolutionFilter[] filters, List<MavenDependency> dependenciesForResolution, List<MavenDependency> declaredDependencies) {
        assert (filters != null) : "Filters must be specified, even if empty";
        ArrayList<MavenDependency> filtered = new ArrayList<MavenDependency>();
        block0: for (MavenDependency candidate : declaredDependencies) {
            for (MavenResolutionFilter filter : filters) {
                if (!filter.accepts(candidate, dependenciesForResolution)) continue block0;
            }
            filtered.add(candidate);
        }
        return filtered;
    }

    public FORMATSTAGETYPE using(MavenResolutionStrategy strategy) throws IllegalArgumentException {
        Validate.notEmpty(this.session.getDependenciesForResolution(), "No dependencies were set for resolution");
        CollectRequest request = this.createCollectRequest(strategy);
        Collection<MavenResolvedArtifact> artifactResults = this.retrieveArtifacts(strategy, request);
        Collection<MavenResolvedArtifact> filteredArtifacts = this.filterArtifacts(artifactResults);
        this.session.getDependenciesForResolution().clear();
        return this.createFormatStage(filteredArtifacts);
    }

    private CollectRequest createCollectRequest(MavenResolutionStrategy strategy) {
        List<MavenDependency> depsForResolution = Collections.unmodifiableList(new ArrayList<MavenDependency>(this.session.getDependenciesForResolution()));
        List<MavenDependency> prefilteredDependencies = this.preFilter(strategy.getPreResolutionFilters(), depsForResolution, depsForResolution);
        ArrayList<MavenDependency> prefilteredDepsList = new ArrayList<MavenDependency>(prefilteredDependencies);
        ArrayList<MavenDependency> depManagement = new ArrayList<MavenDependency>(this.session.getDependencyManagement());
        List<RemoteRepository> repos = this.session.getRemoteRepositories();
        return new CollectRequest(MavenConverter.asDependencies(prefilteredDepsList), MavenConverter.asDependencies(depManagement), repos);
    }

    private Collection<MavenResolvedArtifact> retrieveArtifacts(MavenResolutionStrategy strategy, CollectRequest request) {
        try {
            Collection<MavenResolvedArtifact> retrievedArtifacts = this.session.execute(request, strategy.getResolutionFilters());
            return Collections.unmodifiableCollection(retrievedArtifacts);
        }
        catch (DependencyResolutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause instanceof ArtifactResolutionException) {
                    throw new NoResolvedResultException("Unable to get artifact from the repository, reason: " + e.getMessage());
                }
                if (cause instanceof DependencyCollectionException) {
                    throw new NoResolvedResultException("Unable to collect dependency tree for given dependencies, reason: " + e.getMessage());
                }
                throw new NoResolvedResultException("Unable to collect/resolve dependency tree for a resulution, reason: " + e.getMessage());
            }
            return Collections.emptyList();
        }
    }

    private Collection<MavenResolvedArtifact> filterArtifacts(Collection<MavenResolvedArtifact> artifactResults) {
        RestrictPomArtifactFilter postResolutionFilter = RestrictPomArtifactFilter.INSTANCE;
        ArrayList<MavenResolvedArtifact> filteredArtifacts = new ArrayList<MavenResolvedArtifact>();
        List emptyList = Collections.emptyList();
        for (MavenResolvedArtifact artifact : artifactResults) {
            MavenDependency dependency = MavenDependencies.createDependency((MavenCoordinate)artifact.getCoordinate(), (ScopeType)ScopeType.COMPILE, (boolean)false, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]);
            if (!postResolutionFilter.accepts(dependency, emptyList)) continue;
            filteredArtifacts.add(artifact);
        }
        return Collections.unmodifiableCollection(filteredArtifacts);
    }

    public STRATEGYSTAGETYPE withClassPathResolution(boolean useClassPathResolution) {
        if (!useClassPathResolution) {
            this.session.disableClassPathWorkspaceReader();
        }
        return this.covarientReturn();
    }

    public STRATEGYSTAGETYPE withMavenCentralRepo(boolean useMavenCentral) {
        if (!useMavenCentral) {
            this.session.disableMavenCentral();
        }
        return this.covarientReturn();
    }

    private STRATEGYSTAGETYPE covarientReturn() {
        return (STRATEGYSTAGETYPE)((MavenStrategyStageBase)this.getActualClass().cast(this));
    }

    protected abstract Class<STRATEGYSTAGETYPE> getActualClass();

    protected abstract FORMATSTAGETYPE createFormatStage(Collection<MavenResolvedArtifact> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RestrictPomArtifactFilter implements MavenResolutionFilter
    {
        INSTANCE;


        public boolean accepts(MavenDependency coordinate, List<MavenDependency> dependenciesForResolution) throws IllegalArgumentException {
            if (PackagingType.POM.equals((Object)coordinate.getPackaging())) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Filtering out POM dependency resolution: " + coordinate + "; its transitive dependencies will be included");
                }
                return false;
            }
            return true;
        }
    }
}

