/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.bootstrap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.repository.internal.MavenServiceLocator;
import org.apache.maven.settings.Settings;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.ManualWagonProvider;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.MavenManagerBuilder;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.MavenResolutionFilterWrap;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.resolution.DependencyResult;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenRepositorySystem {
    private final RepositorySystem system = this.getRepositorySystem();

    public RepositorySystemSession getSession(Settings settings) {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        MavenManagerBuilder builder = new MavenManagerBuilder(this.system, settings);
        session.setLocalRepositoryManager(builder.localRepositoryManager());
        session.setWorkspaceReader(builder.workspaceReader());
        session.setTransferListener(builder.transferListerer());
        session.setRepositoryListener(builder.repositoryListener());
        session.setOffline(settings.isOffline());
        session.setMirrorSelector(builder.mirrorSelector());
        session.setProxySelector(builder.proxySelector());
        return session;
    }

    public Collection<ArtifactResult> resolveDependencies(RepositorySystemSession repoSession, MavenWorkingSession swrSession, CollectRequest request, MavenResolutionFilter[] filters) throws DependencyResolutionException {
        DependencyRequest depRequest = new DependencyRequest(request, (DependencyFilter)new MavenResolutionFilterWrap(filters, Collections.unmodifiableList(new ArrayList<MavenDependency>(swrSession.getDependenciesForResolution()))));
        DependencyResult result = this.system.resolveDependencies(repoSession, depRequest);
        return result.getArtifactResults();
    }

    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        return this.system.resolveArtifact(session, request);
    }

    private RepositorySystem getRepositorySystem() {
        MavenServiceLocator locator = new MavenServiceLocator();
        locator.setServices(ModelBuilder.class, (Object[])new ModelBuilder[]{new DefaultModelBuilderFactory().newInstance()});
        locator.setServices(WagonProvider.class, (Object[])new WagonProvider[]{new ManualWagonProvider()});
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        RepositorySystem repositorySystem = (RepositorySystem)locator.getService(RepositorySystem.class);
        return repositorySystem;
    }
}

