/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.task;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.impl.maven.task.MavenWorkingSessionTask;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveVersionFromMetadataTask
implements MavenWorkingSessionTask<String> {
    private static final Logger log = Logger.getLogger(ResolveVersionFromMetadataTask.class.getName());
    private final MavenDependency dependency;

    public ResolveVersionFromMetadataTask(MavenDependency dependency) {
        this.dependency = dependency;
    }

    @Override
    public String execute(MavenWorkingSession session) {
        String declaredVersion = this.dependency.getVersion();
        String resolvedVersion = declaredVersion;
        if (Validate.isNullOrEmptyOrQuestionMark(resolvedVersion) && session.getDependencyManagement().contains(this.dependency)) {
            MavenDependency resolved = null;
            Iterator it = session.getDependencyManagement().iterator();
            while (it.hasNext() && !(resolved = (MavenDependency)it.next()).equals(this.dependency)) {
            }
            resolvedVersion = resolved.getVersion();
            log.log(Level.FINE, "Resolved version {} from the POM file for the artifact {}", new Object[]{resolved.getVersion(), this.dependency.toCanonicalForm()});
        }
        if (Validate.isNullOrEmptyOrQuestionMark(resolvedVersion)) {
            if (log.isLoggable(Level.FINER)) {
                StringBuilder sb = new StringBuilder("Available version management: \n");
                for (MavenDependency depmgmt : session.getDependencyManagement()) {
                    sb.append(depmgmt).append("\n");
                }
                log.log(Level.FINER, sb.toString());
            }
            throw new ResolutionException(MessageFormat.format("Unable to get version for dependency specified by {0}, it was not provided in neither <dependencyManagement> nor <dependencies> sections.", this.dependency.toCanonicalForm()));
        }
        return resolvedVersion;
    }
}

