/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.bootstrap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.wagon.WagonProvider;
import org.eclipse.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.ManualWagonProvider;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.MavenManagerBuilder;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.MavenResolutionFilterWrap;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenRepositorySystem {
    private final RepositorySystem system = this.getRepositorySystem();

    public DefaultRepositorySystemSession getSession(Settings settings) {
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession();
        MavenManagerBuilder builder = new MavenManagerBuilder(this.system, settings);
        session.setLocalRepositoryManager(builder.localRepositoryManager((RepositorySystemSession)session));
        session.setWorkspaceReader(builder.workspaceReader());
        session.setTransferListener(builder.transferListerer());
        session.setRepositoryListener(builder.repositoryListener());
        session.setOffline(settings.isOffline());
        session.setMirrorSelector(builder.mirrorSelector());
        session.setProxySelector(builder.proxySelector());
        session.setDependencyManager(builder.dependencyManager());
        session.setArtifactDescriptorPolicy(builder.artifactRepositoryPolicy());
        session.setDependencyTraverser(builder.dependencyTraverser());
        session.setDependencyGraphTransformer(builder.dependencyGraphTransformer());
        session.setSystemProperties((Map)SecurityActions.getProperties());
        session.setConfigProperties((Map)SecurityActions.getProperties());
        return session;
    }

    public Collection<ArtifactResult> resolveDependencies(RepositorySystemSession repoSession, MavenWorkingSession swrSession, CollectRequest request, MavenResolutionFilter[] filters) throws DependencyResolutionException {
        DependencyRequest depRequest = new DependencyRequest(request, (DependencyFilter)new MavenResolutionFilterWrap(filters, Collections.unmodifiableList(new ArrayList(swrSession.getDependenciesForResolution()))));
        DependencyResult result = this.system.resolveDependencies(repoSession, depRequest);
        return result.getArtifactResults();
    }

    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        return this.system.resolveArtifact(session, request);
    }

    public VersionRangeResult resolveVersionRange(RepositorySystemSession session, VersionRangeRequest request) throws VersionRangeResolutionException {
        return this.system.resolveVersionRange(session, request);
    }

    private RepositorySystem getRepositorySystem() throws UnsupportedOperationException {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.addService(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
        locator.addService(VersionResolver.class, DefaultVersionResolver.class);
        locator.addService(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        locator.addService(MetadataGeneratorFactory.class, SnapshotMetadataGeneratorFactory.class);
        locator.addService(MetadataGeneratorFactory.class, VersionsMetadataGeneratorFactory.class);
        locator.setServices(ModelBuilder.class, (Object[])new ModelBuilder[]{new DefaultModelBuilderFactory().newInstance()});
        locator.setServices(WagonProvider.class, (Object[])new WagonProvider[]{new ManualWagonProvider()});
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        RepositorySystem repositorySystem = (RepositorySystem)locator.getService(RepositorySystem.class);
        if (repositorySystem == null) {
            throw new UnsupportedOperationException("Unable to boostrap Aether repository system. Make sure you're running Maven 3.1.0 or newer.");
        }
        return repositorySystem;
    }
}

