/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.ArtifactResult;
import org.jboss.shrinkwrap.resolver.api.ResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenArtifactInfo;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenArtifactInfoImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.util.IOUtil;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.jboss.shrinkwrap.resolver.spi.format.FormatProcessor;
import org.jboss.shrinkwrap.resolver.spi.format.FormatProcessors;

public class MavenResolvedArtifactImpl
extends MavenArtifactInfoImpl
implements MavenResolvedArtifact {
    private static final Logger log = Logger.getLogger(MavenResolvedArtifactImpl.class.getName());
    private final File file;

    private MavenResolvedArtifactImpl(MavenCoordinate mavenCoordinate, String resolvedVersion, boolean snapshotVersion, String extension, File file, ScopeType scopeType, MavenArtifactInfo[] dependencies) {
        super(mavenCoordinate, resolvedVersion, snapshotVersion, extension, scopeType, dependencies, false);
        this.file = file;
    }

    private MavenResolvedArtifactImpl(Artifact artifact, ScopeType scopeType, List<DependencyNode> children, boolean optional) {
        super(artifact, scopeType, children, optional);
        this.file = MavenResolvedArtifactImpl.artifactToFile(artifact);
    }

    static MavenResolvedArtifact fromArtifactResult(ArtifactResult artifactResult) {
        Artifact artifact = artifactResult.getArtifact();
        DependencyNode root = artifactResult.getRequest().getDependencyNode();
        ScopeType scopeType = ScopeType.RUNTIME;
        try {
            scopeType = ScopeType.fromScopeType((String)root.getDependency().getScope());
        }
        catch (IllegalArgumentException e) {
            log.log(Level.WARNING, "Invalid scope {0} of retrieved dependency {1} will be replaced by <scope>runtime</scope>", new Object[]{root.getDependency().getScope(), root.getDependency().getArtifact()});
        }
        List children = root.getChildren();
        boolean optional = root.getDependency().isOptional();
        return new MavenResolvedArtifactImpl(artifact, scopeType, children, optional);
    }

    public <RETURNTYPE> RETURNTYPE as(Class<RETURNTYPE> returnType) {
        if (returnType == null) {
            throw new IllegalArgumentException("Type must be specified.");
        }
        FormatProcessor processor = FormatProcessors.find(MavenResolvedArtifact.class, returnType);
        return (RETURNTYPE)processor.process((ResolvedArtifact)this, returnType);
    }

    public File asFile() {
        return this.file;
    }

    public InputStream asInputStream() {
        return this.as(InputStream.class);
    }

    public MavenResolvedArtifact asResolvedArtifact() {
        return this.as(MavenResolvedArtifact.class);
    }

    @Override
    public String toString() {
        return "MavenResolvedArtifactImpl [mavenCoordinate=" + this.mavenCoordinate + ", resolvedVersion=" + this.resolvedVersion + ", snapshotVersion=" + this.snapshotVersion + ", extension=" + this.extension + ", dependencies=" + Arrays.toString(this.dependencies) + "]";
    }

    private static File artifactToFile(Artifact artifact) throws IllegalArgumentException {
        if (artifact == null) {
            throw new IllegalArgumentException("ArtifactResult must not be null");
        }
        if ("pom.xml".equals(artifact.getFile().getName())) {
            String artifactId = artifact.getArtifactId();
            String extension = artifact.getExtension();
            String classifier = artifact.getClassifier();
            File root = new File(artifact.getFile().getParentFile(), "target/classes");
            if (!Validate.isNullOrEmpty(classifier) && "tests".equals(classifier)) {
                root = new File(artifact.getFile().getParentFile(), "target/test-classes");
            }
            try {
                File archive = File.createTempFile(artifactId + "-", "." + extension);
                archive.deleteOnExit();
                PackageDirHelper.packageDirectories(archive, root);
                return archive;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to get artifact " + artifactId + " from the classpath", e);
            }
        }
        return artifact.getFile();
    }

    private static class PackageDirHelper {
        private PackageDirHelper() {
            throw new UnsupportedOperationException("No instances should be created; stateless class");
        }

        private static void safelyClose(Closeable closeable) {
            block3: {
                if (closeable != null) {
                    try {
                        closeable.close();
                    }
                    catch (IOException ignore) {
                        if (!log.isLoggable(Level.FINER)) break block3;
                        log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void packageDirectories(File outputFile, File ... directories) throws IOException {
            Validate.notNullAndNoNullValues(directories, "Directories to be packaged must be specified");
            ZipOutputStream zipFile = new ZipOutputStream(new FileOutputStream(outputFile));
            for (File directory : directories) {
                for (String entry : PackageDirHelper.fileListing(directory)) {
                    FileInputStream fis;
                    block5: {
                        fis = null;
                        try {
                            File fileEntry = new File(directory, entry);
                            if (fileEntry.isDirectory()) {
                                zipFile.putNextEntry(new ZipEntry(entry));
                                break block5;
                            }
                            fis = new FileInputStream(fileEntry);
                            zipFile.putNextEntry(new ZipEntry(entry));
                            IOUtil.copy(fis, zipFile);
                        }
                        catch (Throwable throwable) {
                            PackageDirHelper.safelyClose(fis);
                            throw throwable;
                        }
                    }
                    PackageDirHelper.safelyClose(fis);
                }
            }
            PackageDirHelper.safelyClose(zipFile);
        }

        private static List<String> fileListing(File directory) {
            ArrayList<String> list = new ArrayList<String>();
            PackageDirHelper.generateFileList(list, directory, directory);
            return list;
        }

        private static void generateFileList(List<String> list, File root, File file) {
            if (file.isFile()) {
                list.add(PackageDirHelper.getEntryPath(root, file));
            } else if (file.isDirectory()) {
                if (!file.equals(root)) {
                    list.add(PackageDirHelper.getEntryPath(root, file) + File.separatorChar);
                }
                for (File next : file.listFiles()) {
                    PackageDirHelper.generateFileList(list, root, next);
                }
            }
        }

        private static String getEntryPath(File root, File file) {
            return file.getAbsolutePath().substring(root.getAbsolutePath().length() + 1).replace(File.separatorChar, '/');
        }
    }
}

