/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.internal.decrypt;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import org.jboss.shrinkwrap.resolver.impl.maven.internal.decrypt.MavenPlexusCipher;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

class MavenSecurityDispatcher
implements SecDispatcher {
    private static final Logger log = Logger.getLogger(MavenSecurityDispatcher.class.getName());
    private static final String DEFAULT_PASSPHRASE = "settings.security";
    private static final String TYPE_ATTR = "type";
    private static final char ATTR_START = '[';
    private static final char ATTR_STOP = ']';
    private PlexusCipher cipher = new MavenPlexusCipher();
    private SettingsSecurity securitySettings;
    private File securitySettingsPath;

    MavenSecurityDispatcher(File securitySettings) throws InvalidConfigurationFileException {
        this.securitySettingsPath = securitySettings;
        if (Validate.isReadable(securitySettings.getAbsoluteFile())) {
            try {
                this.securitySettings = SecUtil.read((String)securitySettings.getAbsolutePath(), (boolean)true);
            }
            catch (SecDispatcherException e) {
                log.log(Level.WARNING, "Unable to read security configuration from: " + securitySettings.getAbsolutePath() + ". Configuration will be ignored.", e);
            }
        }
    }

    public String decrypt(String str) throws SecDispatcherException {
        if (!this.isEncryptedString(str)) {
            return str;
        }
        String bare = null;
        try {
            bare = this.cipher.unDecorate(str);
        }
        catch (PlexusCipherException e1) {
            throw new SecDispatcherException((Throwable)e1);
        }
        Map<String, String> attr = this.stripAttributes(bare);
        String res = null;
        if (attr == null || attr.get(TYPE_ATTR) == null) {
            String master = this.getMaster();
            try {
                res = this.cipher.decrypt(bare, master);
            }
            catch (PlexusCipherException e) {
                throw new SecDispatcherException("Unable to decrypt encrypted string", (Throwable)e);
            }
        } else {
            String type = attr.get(TYPE_ATTR);
            throw new UnsupportedOperationException("Unable to lookup security dispatched of type " + type);
        }
        return res;
    }

    private Map<String, String> stripAttributes(String str) {
        int start = str.indexOf(91);
        int stop = str.indexOf(93);
        if (start != -1 && stop != -1 && stop > start) {
            if (stop == start + 1) {
                return null;
            }
            String attrs = str.substring(start + 1, stop).trim();
            if (attrs == null || attrs.length() < 1) {
                return null;
            }
            HashMap<String, String> res = null;
            StringTokenizer st = new StringTokenizer(attrs, ", ");
            while (st.hasMoreTokens()) {
                String pair;
                int pos;
                if (res == null) {
                    res = new HashMap<String, String>(st.countTokens());
                }
                if ((pos = (pair = st.nextToken()).indexOf(61)) == -1) continue;
                String key = pair.substring(0, pos).trim();
                if (pos == pair.length()) {
                    res.put(key, null);
                    continue;
                }
                String val = pair.substring(pos + 1);
                res.put(key, val.trim());
            }
            return res;
        }
        return null;
    }

    private boolean isEncryptedString(String str) {
        if (str == null) {
            return false;
        }
        return this.cipher.isEncryptedString(str);
    }

    private String getMaster() throws SecDispatcherException, InvalidConfigurationFileException {
        if (this.securitySettings == null) {
            throw new InvalidConfigurationFileException("Unable to get security configuration from " + this.securitySettingsPath.getPath() + ". Please define path to the settings-security.xml file via -D" + DEFAULT_PASSPHRASE + ", or put it the the default location defined by Maven.");
        }
        String master = this.securitySettings.getMaster();
        if (master == null) {
            throw new InvalidConfigurationFileException("Security configuration from " + this.securitySettingsPath.getPath() + " does not contain master password");
        }
        try {
            return this.cipher.decryptDecorated(master, DEFAULT_PASSPHRASE);
        }
        catch (PlexusCipherException e) {
            throw new SecDispatcherException((Throwable)e);
        }
    }
}

