/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.plugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.classrealm.ClassRealmManager;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenArtifactInfo;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.plugin.AbstractResolverMojo;
import org.jboss.shrinkwrap.resolver.plugin.PropagateExecutionContextMojo;
import org.jboss.shrinkwrap.resolver.plugin.SecurityActions;

@Mojo(name="dependency-tree", requiresDirectInvocation=true, requiresDependencyCollection=ResolutionScope.TEST)
public class DependencyTreeMojo
extends AbstractResolverMojo {
    private static final String OUTPUT_DELIMITER;
    @Parameter(defaultValue="${outputFile}")
    private File outputFile;
    @Parameter(defaultValue="${scope}")
    private String scope;
    @Component
    private ClassRealmManager classRealmManager;

    public void execute() {
        PropagateExecutionContextMojo mojo = new PropagateExecutionContextMojo();
        mojo.setNamespace("maven.execution.");
        mojo.setSession(this.session);
        mojo.execute();
        SecurityActions.addProperties(this.session.getUserProperties());
        MavenProject project = this.session.getCurrentProject();
        ScopeType[] scopes = ScopeType.values();
        if (this.scope != null && !this.scope.isEmpty()) {
            scopes = new ScopeType[]{ScopeType.fromScopeType((String)this.scope)};
        }
        ClassLoader cls = this.getCombinedClassLoader(this.classRealmManager);
        MavenResolvedArtifact[] artifacts = project.getDependencies() == null || project.getDependencies().isEmpty() ? new MavenResolvedArtifact[]{} : (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.configureResolverViaPlugin((ClassLoader)cls).importDependencies(scopes)).resolve()).withTransitivity()).asResolvedArtifact();
        StringBuilder projectGAV = new StringBuilder();
        projectGAV.append(project.getGroupId()).append(":").append(project.getArtifactId()).append(":").append(project.getPackaging()).append(":").append(project.getVersion()).append("\n");
        String dependencyTree = DependencyTreeMojo.buildDependencyTree(projectGAV, "+- ", (MavenArtifactInfo[])artifacts);
        if (this.outputFile != null) {
            try (FileWriter writer2 = new FileWriter(this.outputFile);){
                writer2.write(dependencyTree);
                this.getLog().info((CharSequence)("Dependency tree output was written into: " + this.outputFile.getAbsolutePath()));
            }
            catch (IOException writer2) {}
        } else {
            String outputString = OUTPUT_DELIMITER + "\nShrinkWrap Maven: Dependency Tree\n" + OUTPUT_DELIMITER + "\n" + dependencyTree + OUTPUT_DELIMITER;
            this.getLog().info((CharSequence)outputString);
        }
    }

    private static String buildDependencyTree(StringBuilder sb, String indent, MavenArtifactInfo[] artifacts) {
        int length = artifacts.length - 1;
        for (int i = 0; i <= length; ++i) {
            MavenArtifactInfo artifact = artifacts[i];
            String parsedIndent = indent;
            String nextLevelIndent = indent.replaceAll("\\+- $", "\\|  ") + "+- ";
            if (i == length) {
                parsedIndent = parsedIndent.replaceAll("\\+- $", "\\\\- ");
                nextLevelIndent = indent.replaceAll("\\+- $", "   ") + "+- ";
            }
            sb.append(parsedIndent).append(artifact.getCoordinate().toCanonicalForm()).append(" [").append(artifact.getScope()).append("]").append("\n");
            DependencyTreeMojo.buildDependencyTree(sb, nextLevelIndent, artifact.getDependencies());
        }
        return sb.toString();
    }

    private ClassLoader getCombinedClassLoader(ClassRealmManager manager) {
        ClassRealm mavenApi;
        ClassRealm core;
        ArrayList<URL> urlList = new ArrayList<URL>();
        ClassLoader threadCL = SecurityActions.getThreadContextClassLoader();
        if (threadCL instanceof URLClassLoader) {
            urlList.addAll(Arrays.asList(((URLClassLoader)threadCL).getURLs()));
        }
        if ((core = manager.getCoreRealm()) != null) {
            urlList.addAll(Arrays.asList(core.getURLs()));
        }
        if ((mavenApi = manager.getMavenApiRealm()) != null) {
            urlList.addAll(Arrays.asList(mavenApi.getURLs()));
        }
        URLClassLoader cl = new URLClassLoader(urlList.toArray(new URL[0]), threadCL);
        return cl;
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 79; ++i) {
            sb.append('-');
        }
        OUTPUT_DELIMITER = sb.toString();
    }
}

