/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnknownExtensionTypeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final Method GET_EXTENSION_MAPPING = AccessController.doPrivileged(new PrivilegedAction<Method>(){

        @Override
        public Method run() {
            try {
                return Configuration.class.getMethod("getExtensionMappings", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Incorrect extension mappings method defined for error message; development error in ShrinkWrap");
            }
        }
    });

    private <T extends Assignable> UnknownExtensionTypeException(Class<T> type) {
        super("The current configuration has no mapping for type " + type.getCanonicalName() + ", unable to determine extension. Either add a mapping via " + GET_EXTENSION_MAPPING.toString() + " or manually assign a name.");
    }

    static <T extends Assignable> UnknownExtensionTypeException newInstance(Class<T> type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("type must be specified");
        }
        return new UnknownExtensionTypeException(type);
    }
}

