/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.formatter;

import java.util.TreeSet;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.formatter.Formatter;

enum FullFormatter implements Formatter
{
    INSTANCE;


    @Override
    public String format(Archive<?> archive) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder(archive.getName()).append(':').append('\n');
        TreeSet<String> archiveContents = new TreeSet<String>();
        for (ArchivePath path : archive.getContent().keySet()) {
            archiveContents.add(path.get());
            for (ArchivePath parentPath = path.getParent(); parentPath != null; parentPath = parentPath.getParent()) {
                archiveContents.add(parentPath.get());
            }
        }
        for (String pathEntry : archiveContents) {
            sb.append(pathEntry).append('\n');
        }
        int firstLeadingSlash = sb.indexOf(String.valueOf('/'));
        sb.delete(firstLeadingSlash, firstLeadingSlash + 2);
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

