/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.classloader;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;

public class ShrinkWrapClassLoader
extends URLClassLoader
implements Closeable {
    private static final Logger log = Logger.getLogger(ShrinkWrapClassLoader.class.getName());
    private static final String EMPTY = "";
    private final List<InputStream> openedStreams = new ArrayList<InputStream>();
    private final ArchivePath classPrefix;

    public ShrinkWrapClassLoader(Archive<?> ... archives) {
        super(new URL[0]);
        if (archives == null) {
            throw new IllegalArgumentException("Archives must be specified");
        }
        this.addArchives(archives);
        this.classPrefix = ArchivePaths.root();
    }

    public ShrinkWrapClassLoader(ClassLoader parent, Archive<?> ... archives) {
        this(parent, (String)null, archives);
    }

    public ShrinkWrapClassLoader(ClassLoader parent, String classPrefix, Archive<?> ... archives) {
        super(new URL[0], parent);
        if (archives == null) {
            throw new IllegalArgumentException("Archives must be specified");
        }
        this.addArchives(archives);
        this.classPrefix = classPrefix == null ? ArchivePaths.root() : ArchivePaths.create(classPrefix);
    }

    private void addArchives(Archive<?>[] archives) {
        for (Archive<?> archive : archives) {
            this.addArchive(archive);
        }
    }

    private void addArchive(final Archive<?> archive) {
        try {
            this.addURL(new URL(null, "archive:" + archive.getName() + "/", new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(final URL u) throws IOException {
                    return new URLConnection(u){

                        @Override
                        public void connect() throws IOException {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public InputStream getInputStream() throws IOException {
                            ArchivePath rawPath = this.convertToArchivePath(u);
                            ArchivePath path = ArchivePaths.create(ShrinkWrapClassLoader.this.classPrefix, rawPath);
                            Node node = archive.get(path);
                            if (node == null) {
                                throw new FileNotFoundException("Requested path: " + path + " does not exist in " + archive.toString());
                            }
                            Asset asset = node.getAsset();
                            if (asset == null) {
                                return null;
                            }
                            InputStream input = asset.openStream();
                            1 var6_6 = this;
                            synchronized (var6_6) {
                                ShrinkWrapClassLoader.this.openedStreams.add(input);
                            }
                            return input;
                        }

                        private ArchivePath convertToArchivePath(URL url) {
                            String path = url.getPath();
                            path = path.replace(archive.getName(), ShrinkWrapClassLoader.EMPTY);
                            return ArchivePaths.create(path);
                        }
                    };
                }
            }));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create URL for archive: " + archive.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ShrinkWrapClassLoader shrinkWrapClassLoader = this;
        synchronized (shrinkWrapClassLoader) {
            for (InputStream stream : this.openedStreams) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    log.warning("Could not close opened inputstream: " + e);
                }
            }
            this.openedStreams.clear();
        }
    }
}

