/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.nio2.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;

public class SeekableInMemoryByteChannel
implements SeekableByteChannel {
    private int position;
    private volatile boolean open = true;
    private byte[] contents;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeekableInMemoryByteChannel() {
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            this.position = 0;
            this.contents = new byte[0];
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer destination) throws IOException {
        int numBytesToRead;
        this.checkClosed();
        if (destination == null) {
            throw new IllegalArgumentException("Destination buffer must be supplied");
        }
        int spaceInBuffer = destination.remaining();
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            int numBytesRemainingInContent = this.contents.length - this.position;
            if (numBytesRemainingInContent <= 0) {
                return -1;
            }
            numBytesToRead = numBytesRemainingInContent >= spaceInBuffer ? spaceInBuffer : numBytesRemainingInContent;
            destination.put(this.contents, this.position, numBytesToRead);
            this.position += numBytesToRead;
        }
        return numBytesToRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer source) throws IOException {
        this.checkClosed();
        if (source == null) {
            throw new IllegalArgumentException("Source buffer must be supplied");
        }
        int totalBytes = source.remaining();
        byte[] readContents = new byte[totalBytes];
        source.get(readContents);
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            this.contents = this.concat(this.contents, readContents, this.position);
            this.position += totalBytes;
        }
        return totalBytes;
    }

    private byte[] concat(byte[] input1, byte[] input2, int position) {
        assert (input1 != null) : "Input 1 must be specified";
        assert (input2 != null) : "Input 2 must be specified";
        assert (position >= 0) : "Position must be 0 or higher";
        int newSize = position < input1.length ? input1.length + input2.length : position + input2.length;
        byte[] merged = new byte[newSize];
        System.arraycopy(input1, 0, merged, 0, input1.length);
        System.arraycopy(input2, 0, merged, position, input2.length);
        return merged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() throws IOException {
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            return this.position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        if (newPosition > Integer.MAX_VALUE || newPosition < 0L) {
            throw new IllegalArgumentException("Valid position for this channel is between 0 and 2147483647");
        }
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            this.position = (int)newPosition;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() throws IOException {
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            return this.contents.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This implementation permits a size of 0 to 2147483647 inclusive");
        }
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            int newSize = (int)size;
            int currentSize = (int)this.size();
            if (this.position > newSize) {
                this.position = newSize;
            }
            if (currentSize > newSize) {
                byte[] newContents = new byte[newSize];
                System.arraycopy(this.contents, 0, newContents, 0, newSize);
                this.contents = newContents;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContents() {
        byte[] copy;
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            int length = this.contents.length;
            copy = new byte[length];
            System.arraycopy(this.contents, 0, copy, 0, this.contents.length);
        }
        return new ByteArrayInputStream(copy);
    }

    private void checkClosed() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }
}

