/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.glassfish.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.glassfish.api.ShrinkwrapReadableArchive;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.ArchiveAsset;
import org.jboss.shrinkwrap.impl.base.asset.DirectoryAsset;

public class ShrinkwrapReadableArchiveImpl
extends AssignableBase
implements ShrinkwrapReadableArchive {
    private final Archive<?> archive;

    public ShrinkwrapReadableArchiveImpl(Archive<?> archive) {
        Validate.notNull(archive, (String)"Archive must be specified");
        this.archive = archive;
    }

    protected Archive<?> getArchive() {
        return this.archive;
    }

    public boolean delete() {
        return false;
    }

    public boolean exists() {
        return true;
    }

    public boolean exists(String path) throws IOException {
        return this.archive.contains(ArchivePaths.create((String)path));
    }

    public InputStream getEntry(String path) throws IOException {
        return this.archive.get(ArchivePaths.create((String)path)).openStream();
    }

    public long getEntrySize(String path) {
        return 0L;
    }

    public ReadableArchive getParentArchive() {
        return null;
    }

    public void setParentArchive(ReadableArchive arg0) {
    }

    public ReadableArchive getSubArchive(String path) throws IOException {
        Asset archiveAsset = this.archive.get(ArchivePaths.create((String)path));
        if (archiveAsset instanceof ArchiveAsset) {
            return (ReadableArchive)((ArchiveAsset)archiveAsset).getArchive().as(ShrinkwrapReadableArchive.class);
        }
        throw new IOException(path + " not a Archive");
    }

    public void open(URI arg0) throws IOException {
    }

    public boolean renameTo(String arg0) {
        return false;
    }

    public void close() throws IOException {
    }

    public Enumeration<String> entries() {
        ArrayList<String> entries = new ArrayList<String>();
        for (Map.Entry entry : this.archive.getContent().entrySet()) {
            entries.add(((ArchivePath)entry.getKey()).get());
        }
        return Collections.enumeration(entries);
    }

    public Enumeration<String> entries(String path) {
        ArrayList<String> entries = new ArrayList<String>();
        for (Map.Entry entry : this.archive.getContent().entrySet()) {
            if (!((ArchivePath)entry.getKey()).get().startsWith(path)) continue;
            entries.add(((ArchivePath)entry.getKey()).get());
        }
        return Collections.enumeration(entries);
    }

    public long getArchiveSize() throws SecurityException {
        return -1L;
    }

    public Collection<String> getDirectories() throws IOException {
        ArrayList<String> entries = new ArrayList<String>();
        for (Map.Entry entry : this.archive.getContent().entrySet()) {
            if (entry.getValue() != DirectoryAsset.INSTANCE) continue;
            entries.add(((ArchivePath)entry.getKey()).get());
        }
        return entries;
    }

    public Manifest getManifest() throws IOException {
        ArchivePath manifestPath = ArchivePaths.create((String)"META-INF/MANIFEST.MF");
        if (this.archive.contains(manifestPath)) {
            return new Manifest(this.archive.get(manifestPath).openStream());
        }
        return null;
    }

    public String getName() {
        return this.archive.getName();
    }

    public URI getURI() {
        try {
            return new URI("archive://" + this.archive.getName());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isDirectory(String path) {
        return this.archive.get(ArchivePaths.create((String)path)) == DirectoryAsset.INSTANCE;
    }
}

