/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.ArchiveAsset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public abstract class ArchiveBase<T extends Archive<T>>
implements Archive<T> {
    private static final Logger log = Logger.getLogger(ArchiveBase.class.getName());
    private final String name;

    protected ArchiveBase(String name) throws IllegalArgumentException {
        Validate.notNullOrEmpty(name, "name must be specified");
        this.name = name;
    }

    public T add(String target, Asset asset) throws IllegalArgumentException {
        Validate.notNullOrEmpty(target, "target must be specified");
        Validate.notNull(asset, "asset must be specified");
        BasicPath path = new BasicPath(target);
        return (T)this.add(path, asset);
    }

    public T add(Path path, String name, Asset asset) {
        Validate.notNull(path, "No path was specified");
        Validate.notNullOrEmpty(name, "No target name name was specified");
        Validate.notNull(asset, "No asset was was specified");
        BasicPath resolvedPath = new BasicPath(path, name);
        return (T)this.add(resolvedPath, asset);
    }

    public Asset get(String path) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, "No path was specified");
        BasicPath realPath = new BasicPath(path);
        return this.get(realPath);
    }

    public T add(Path path, Archive<?> archive) {
        Validate.notNull(path, "No path was specified");
        Validate.notNull(archive, "No archive was specified");
        String archiveName = archive.getName();
        BasicPath contentPath = new BasicPath(path, archiveName);
        ArchiveAsset archiveAsset = new ArchiveAsset(archive);
        return (T)this.add(contentPath, archiveAsset);
    }

    public final String getName() {
        return this.name;
    }

    public T merge(Archive<?> source) throws IllegalArgumentException {
        return this.merge(new BasicPath(), source);
    }

    public T merge(Path path, Archive<?> source) throws IllegalArgumentException {
        Validate.notNull(path, "No path was specified");
        Validate.notNull(source, "No source archive was specified");
        Map sourceContent = source.getContent();
        Validate.notNull(sourceContent, "Source archive content can not be null.");
        for (Map.Entry contentEntry : sourceContent.entrySet()) {
            Asset asset = (Asset)contentEntry.getValue();
            Path assetPath = (Path)contentEntry.getKey();
            if (path != null) {
                assetPath = new BasicPath(path, assetPath);
            }
            this.add(assetPath, asset);
        }
        return this.covariantReturn();
    }

    protected abstract Class<T> getActualClass();

    protected final T covariantReturn() {
        try {
            return (T)((Archive)this.getActualClass().cast(this));
        }
        catch (ClassCastException cce) {
            log.log(Level.SEVERE, "The class specified by getActualClass is not a valid assignment target for this instance; developer error");
            throw cce;
        }
    }
}

