/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.impl.base.ArchiveBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.ArchiveAsset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public abstract class MemoryMapArchiveBase<T extends Archive<T>>
extends ArchiveBase<T>
implements Archive<T> {
    private static final Logger log = Logger.getLogger(MemoryMapArchiveBase.class.getName());
    private static final char NEWLINE = '\n';
    private static final char COLON = ':';
    private final Map<Path, Asset> content = new ConcurrentHashMap<Path, Asset>();
    private final Map<Path, ArchiveAsset> nestedArchives = new ConcurrentHashMap<Path, ArchiveAsset>();

    public MemoryMapArchiveBase() {
        this("Archive-" + UUID.randomUUID().toString() + ".jar");
    }

    public MemoryMapArchiveBase(String archiveName) {
        super(archiveName);
    }

    public T add(Path path, Asset asset) {
        Validate.notNull(path, "No path was specified");
        Validate.notNull(asset, "No asset was specified");
        this.content.put(path, asset);
        return this.covariantReturn();
    }

    @Override
    public T add(Path path, Archive<?> archive) {
        super.add(path, archive);
        BasicPath archivePath = new BasicPath(path, archive.getName());
        Asset asset = this.get(archivePath);
        if (asset instanceof ArchiveAsset) {
            ArchiveAsset archiveAsset = (ArchiveAsset)ArchiveAsset.class.cast(asset);
            this.nestedArchives.put(archivePath, archiveAsset);
        }
        return this.covariantReturn();
    }

    public boolean contains(Path path) {
        Validate.notNull(path, "No path was specified");
        boolean found = this.content.containsKey(path);
        if (!found) {
            found = this.nestedContains(path);
        }
        return found;
    }

    public boolean delete(Path path) {
        Validate.notNull(path, "No path was specified");
        return this.content.remove(path) != null;
    }

    public Asset get(Path path) {
        Validate.notNull(path, "No path was specified");
        Asset asset = this.content.get(path);
        if (asset == null && this.contains(path)) {
            asset = this.getNestedAsset(path);
        }
        return asset;
    }

    public Map<Path, Asset> getContent() {
        return Collections.unmodifiableMap(this.content);
    }

    public String toString(boolean verbose) {
        if (verbose) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName()).append(':').append('\n');
            ArrayList<Path> paths = new ArrayList<Path>(this.content.keySet());
            Collections.sort(paths);
            for (Path path : paths) {
                sb.append(path.get()).append('\n');
            }
            return sb.toString();
        }
        return this.toString();
    }

    private boolean nestedContains(Path path) {
        for (Map.Entry<Path, ArchiveAsset> nestedArchiveEntry : this.nestedArchives.entrySet()) {
            Path archivePath = nestedArchiveEntry.getKey();
            ArchiveAsset archiveAsset = nestedArchiveEntry.getValue();
            if (!this.startsWith(path, archivePath)) continue;
            Archive<?> nestedArchive = archiveAsset.getArchive();
            Path nestedAssetPath = this.getNestedPath(path, archivePath);
            return nestedArchive.contains(nestedAssetPath);
        }
        return false;
    }

    private Asset getNestedAsset(Path path) {
        for (Map.Entry<Path, ArchiveAsset> nestedArchiveEntry : this.nestedArchives.entrySet()) {
            Path archivePath = nestedArchiveEntry.getKey();
            ArchiveAsset archiveAsset = nestedArchiveEntry.getValue();
            if (!this.startsWith(path, archivePath)) continue;
            Archive<?> nestedArchive = archiveAsset.getArchive();
            Path nestedAssetPath = this.getNestedPath(path, archivePath);
            return nestedArchive.get(nestedAssetPath);
        }
        return null;
    }

    private boolean startsWith(Path fullPath, Path startingPath) {
        String context = fullPath.get();
        String startingContext = startingPath.get();
        return context.startsWith(startingContext);
    }

    private Path getNestedPath(Path fullPath, Path basePath) {
        String context = fullPath.get();
        String baseContent = basePath.get();
        String nestedArchiveContext = context.substring(baseContent.length());
        return new BasicPath(nestedArchiveContext);
    }
}

