/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.File;
import java.net.URL;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.WebContainer;
import org.jboss.shrinkwrap.impl.base.ContainerBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.asset.FileAsset;
import org.jboss.shrinkwrap.impl.base.asset.UrlAsset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public abstract class WebContainerBase<T extends Archive<T>>
extends ContainerBase<T>
implements WebContainer<T> {
    protected WebContainerBase(Class<T> actualType, Archive<?> archive) {
        super(actualType, archive);
    }

    protected abstract Path getWebPath();

    public T setWebXML(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.setWebXML(new ClassLoaderAsset(resourceName));
    }

    public T setWebXML(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setWebXML(new FileAsset(resource));
    }

    public T setWebXML(URL resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setWebXML(new UrlAsset(resource));
    }

    public T setWebXML(Asset resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addWebResource("web.xml", resource);
    }

    public T addWebResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addWebResource(AssetUtil.getNameForClassloaderResource(resourceName), (Asset)new ClassLoaderAsset(resourceName));
    }

    public T addWebResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addWebResource(resource.getName(), (Asset)new FileAsset(resource));
    }

    public T addWebResource(String target, String resourceName) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addWebResource((Path)new BasicPath(target), (Asset)new ClassLoaderAsset(resourceName));
    }

    public T addWebResource(String target, File resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        return this.addWebResource((Path)new BasicPath(target), (Asset)new FileAsset(resource));
    }

    public T addWebResource(String target, URL resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        return this.addWebResource((Path)new BasicPath(target), (Asset)new UrlAsset(resource));
    }

    public T addWebResource(String target, Asset resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        return this.addWebResource((Path)new BasicPath(target), resource);
    }

    public T addWebResource(Path target, String resourceName) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addWebResource(target, (Asset)new ClassLoaderAsset(resourceName));
    }

    public T addWebResource(Path target, File resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        return this.addWebResource(target, (Asset)new FileAsset(resource));
    }

    public T addWebResource(Path target, URL resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        return this.addWebResource(target, (Asset)new UrlAsset(resource));
    }

    public T addWebResource(Path target, Asset resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        BasicPath location = new BasicPath(this.getWebPath(), target);
        return this.add((Path)location, resource);
    }
}

