/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter.zip;

import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.exporter.ArchiveExportException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArchiveJarInputStream
extends JarInputStream {
    private static final InputStream EMPTY_STREAM = new InputStream(){

        public int read() throws IOException {
            return -1;
        }
    };
    private static final String META_INF_DIR = "META-INF";
    private final LinkedList<Iterator<Node>> entryItr = new LinkedList();
    private final Node root;
    private final Manifest manifest;
    private InputStream currentEntryStream = EMPTY_STREAM;
    private boolean closed;

    public ArchiveJarInputStream(Archive<?> archive) throws IOException {
        super(EMPTY_STREAM);
        this.root = archive.get(ArchivePaths.root());
        this.manifest = null;
        this.entryItr.add(this.root.getChildren().iterator());
    }

    static long javaToDosTime(long time) {
        Date d = new Date(time);
        int year = d.getYear() + 1900;
        if (year < 1980) {
            return 0x210000L;
        }
        return year - 1980 << 25 | d.getMonth() + 1 << 21 | d.getDate() << 16 | d.getHours() << 11 | d.getMinutes() << 5 | d.getSeconds() >> 1;
    }

    @Override
    public ZipEntry getNextEntry() throws IOException {
        return this.getNextJarEntry();
    }

    @Override
    public JarEntry getNextJarEntry() throws IOException {
        Iterator<Node> topItr;
        this.closeEntry();
        Iterator<Node> iterator = topItr = this.entryItr.size() > 0 ? this.entryItr.getFirst() : null;
        if (topItr == null) {
            return null;
        }
        if (!topItr.hasNext()) {
            this.entryItr.removeFirst();
            return this.getNextJarEntry();
        }
        Node nextEntry = topItr.next();
        String entryName = this.getEntryName(nextEntry);
        if (nextEntry.getAsset() == null) {
            Set children = nextEntry.getChildren();
            if (entryName.equalsIgnoreCase(META_INF_DIR)) {
                children = nextEntry.getChildren();
            }
            this.entryItr.add(children.iterator());
            entryName = this.fixDirectoryName(entryName);
        }
        this.openCurrent(nextEntry);
        Attributes attributes = null;
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            attributes = manifest.getAttributes(entryName);
        }
        return new VirtualJarEntry(entryName, nextEntry, attributes);
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.checkForEoSAndReturn(this.currentEntryStream.read());
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        return this.checkForEoSAndReturn(this.currentEntryStream.read(b, off, len));
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return this.currentEntryStream.available() > 0 ? 1 : 0;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public void closeEntry() throws IOException {
        if (this.currentEntryStream != null) {
            this.currentEntryStream.close();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        return this.currentEntryStream.skip(n);
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
    }

    private int checkForEoSAndReturn(int result) throws IOException {
        if (result == -1) {
            this.closeEntry();
            this.currentEntryStream = EMPTY_STREAM;
        }
        return result;
    }

    private void openCurrent(Node current) throws IOException {
        if (current.getAsset() == null) {
            this.currentEntryStream = EMPTY_STREAM;
        } else {
            try {
                this.currentEntryStream = current.getAsset().openStream();
            }
            catch (RuntimeException e) {
                throw new ArchiveExportException((Throwable)e);
            }
        }
    }

    private String getEntryName(Node entry) {
        return entry.getPath().get().substring(1);
    }

    private String fixDirectoryName(String name) {
        if (!name.endsWith("/")) {
            return name + "/";
        }
        return name;
    }

    public static class VirtualJarEntry
    extends JarEntry {
        private final Node virtualFile;
        private final Attributes attributes;

        public VirtualJarEntry(String name, Node virtualFile, Attributes attributes) {
            super(name);
            this.virtualFile = virtualFile;
            this.attributes = attributes;
        }

        public Attributes getAttributes() throws IOException {
            return this.attributes;
        }

        public long getTime() {
            return ArchiveJarInputStream.javaToDosTime(System.currentTimeMillis());
        }

        public boolean isDirectory() {
            return this.virtualFile.getAsset() == null;
        }

        public Certificate[] getCertificates() {
            CodeSigner[] signers = this.getCodeSigners();
            if (signers == null) {
                return null;
            }
            ArrayList<? extends Certificate> certs = new ArrayList<Certificate>();
            for (CodeSigner signer : signers) {
                certs.addAll(signer.getSignerCertPath().getCertificates());
            }
            return certs.toArray(new Certificate[certs.size()]);
        }

        public CodeSigner[] getCodeSigners() {
            throw new UnsupportedOperationException("getCodeSigners()");
        }
    }
}

