/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.container;

import java.io.File;
import java.net.URL;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.EnterpriseContainer;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.asset.FileAsset;
import org.jboss.shrinkwrap.impl.base.asset.UrlAsset;
import org.jboss.shrinkwrap.impl.base.container.ContainerBase;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public abstract class EnterpriseContainerBase<T extends Archive<T>>
extends ContainerBase<T>
implements EnterpriseContainer<T> {
    protected EnterpriseContainerBase(Class<T> actualType, Archive<?> archive) {
        super(actualType, archive);
    }

    protected abstract Path getApplicationPath();

    public T setApplicationXML(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.setApplicationXML(new ClassLoaderAsset(resourceName));
    }

    public T setApplicationXML(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.setApplicationXML(new FileAsset(resource));
    }

    public T setApplicationXML(URL resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.setApplicationXML(new UrlAsset(resource));
    }

    public T setApplicationXML(Asset resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addApplicationResource(resource, "application.xml");
    }

    public T addApplicationResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.addApplicationResource((Asset)new ClassLoaderAsset(resourceName), resourceName);
    }

    public T addApplicationResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addApplicationResource((Asset)new FileAsset(resource), resource.getName());
    }

    public T addApplicationResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addApplicationResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addApplicationResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addApplicationResource((Asset)new FileAsset(resource), target);
    }

    public T addApplicationResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addApplicationResource((Asset)new UrlAsset(resource), target);
    }

    public T addApplicationResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addApplicationResource(resource, (Path)new BasicPath(target));
    }

    public T addApplicationResource(String resourceName, Path target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addApplicationResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addApplicationResource(File resource, Path target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addApplicationResource((Asset)new FileAsset(resource), target);
    }

    public T addApplicationResource(URL resource, Path target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addApplicationResource((Asset)new UrlAsset(resource), target);
    }

    public T addApplicationResource(Asset resource, Path target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        BasicPath location = new BasicPath(this.getApplicationPath(), target);
        return this.add(resource, (Path)location);
    }

    protected abstract Path getModulePath();

    public T addModule(Archive<?> archive) throws IllegalArgumentException {
        Validate.notNull(archive, "Archive must be specified");
        return this.add(archive, this.getModulePath());
    }

    public T addModule(String resourceName) {
        Validate.notNull(resourceName, "ResourceName must be specified");
        BasicPath location = new BasicPath(AssetUtil.getNameForClassloaderResource(resourceName));
        return this.addModule(resourceName, (Path)location);
    }

    public T addModule(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addModule(resource, resource.getName());
    }

    public T addModule(File resource, Path targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        FileAsset asset = new FileAsset(resource);
        return this.addModule((Asset)asset, targetPath);
    }

    public T addModule(String resourceName, Path targetPath) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        ClassLoaderAsset asset = new ClassLoaderAsset(resourceName);
        return this.addModule((Asset)asset, targetPath);
    }

    public T addModule(URL resource, Path targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        UrlAsset asset = new UrlAsset(resource);
        return this.addModule((Asset)asset, targetPath);
    }

    public T addModule(File resource, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addModule(resource, (Path)new BasicPath(targetPath));
    }

    public T addModule(Asset resource, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addModule(resource, (Path)new BasicPath(targetPath));
    }

    public T addModule(String resourceName, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resourceName, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addModule(resourceName, (Path)new BasicPath(targetPath));
    }

    public T addModule(URL resource, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addModule(resource, (Path)new BasicPath(targetPath));
    }

    public T addModule(Asset resource, Path targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.add(resource, (Path)new BasicPath(this.getModulePath(), targetPath));
    }
}

