/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.IOException;
import java.io.PipedInputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.exporter.ArchiveExportException;

class FutureCompletionInputStream
extends PipedInputStream {
    private static final Logger log = Logger.getLogger(FutureCompletionInputStream.class.getName());
    private static final int EOF = -1;
    private final Future<?> job;

    public FutureCompletionInputStream(Future<?> job) {
        this.job = job;
    }

    @Override
    public synchronized int read() throws IOException {
        int bytesRead = super.read();
        this.awaitOnFutureOnDone(bytesRead);
        return bytesRead;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        this.awaitOnFutureOnDone(bytesRead);
        return bytesRead;
    }

    private void awaitOnFutureOnDone(int bytesRead) throws ArchiveExportException {
        if (bytesRead == -1) {
            try {
                this.job.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                log.log(Level.WARNING, "We've been interrupted while waiting for the export process to complete", e);
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                if (cause == null) {
                    throw new IllegalStateException("Cause of execution failure not specified: ", ee);
                }
                throw new ArchiveExportException(cause);
            }
        }
    }
}

