/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.exporter.ArchiveExportException;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOnDemandInputStream<T extends OutputStream>
extends InputStream {
    private static final int BUFFER_LENGTH = 4096;
    private final Iterator<Node> nodesIterator;
    protected T outputStream;
    private final ByteArrayOutputStream bufferedOutputStream = new ByteArrayOutputStream();
    private InputStream currentNodeStream;
    private ByteArrayInputStream bufferInputStream;
    private boolean outputStreamClosed = false;
    private ArchivePath currentPath = null;

    public AbstractOnDemandInputStream(Archive<?> archive) {
        Collection nodes = archive.getContent().values();
        this.nodesIterator = nodes.iterator();
    }

    @Override
    public int read() throws IOException {
        int value;
        if (this.outputStream == null && !this.outputStreamClosed) {
            this.outputStream = this.createOutputStream(this.bufferedOutputStream);
        }
        int n = value = this.bufferInputStream != null ? this.bufferInputStream.read() : -1;
        if (value == -1) {
            if (this.currentNodeStream != null) {
                try {
                    this.doCopy();
                    this.bufferInputStream = new ByteArrayInputStream(this.bufferedOutputStream.toByteArray());
                    this.bufferedOutputStream.reset();
                    return this.read();
                }
                catch (Throwable t) {
                    throw new ArchiveExportException("Failed to write asset to output: " + this.currentPath.get(), t);
                }
            }
            if (this.nodesIterator.hasNext()) {
                Node currentNode = this.nodesIterator.next();
                this.currentPath = currentNode.getPath();
                String pathName = PathUtil.optionallyRemovePrecedingSlash(this.currentPath.get());
                boolean isDirectory = currentNode.getAsset() == null;
                String resolvedPath = pathName;
                if (isDirectory) {
                    resolvedPath = PathUtil.optionallyAppendSlash(resolvedPath);
                    this.startAsset(resolvedPath);
                    this.endAsset();
                } else {
                    this.startAsset(resolvedPath);
                    try {
                        this.currentNodeStream = currentNode.getAsset().openStream();
                        this.doCopy();
                    }
                    catch (Throwable t) {
                        throw new ArchiveExportException("Failed to write asset to output: " + this.currentPath.get(), t);
                    }
                    this.bufferInputStream = new ByteArrayInputStream(this.bufferedOutputStream.toByteArray());
                    this.bufferedOutputStream.reset();
                }
            } else {
                if (!this.outputStreamClosed) {
                    ((OutputStream)this.outputStream).close();
                    this.outputStreamClosed = true;
                    this.bufferInputStream = new ByteArrayInputStream(this.bufferedOutputStream.toByteArray());
                    this.bufferedOutputStream.close();
                    this.currentNodeStream = null;
                    this.outputStream = null;
                    return this.read();
                }
                return -1;
            }
            return this.read();
        }
        return value;
    }

    private void doCopy() throws IOException {
        int copied = IOUtil.copy(this.currentNodeStream, this.outputStream, 4096);
        if (copied < 4096 || copied == -1) {
            this.currentNodeStream.close();
            this.currentNodeStream = null;
            this.endAsset();
        }
    }

    private void startAsset(String path) throws IOException {
        this.putNextEntry(this.outputStream, path);
    }

    private void endAsset() throws IOException {
        this.closeEntry(this.outputStream);
    }

    protected abstract T createOutputStream(OutputStream var1) throws IOException;

    protected abstract void putNextEntry(T var1, String var2) throws IOException;

    protected abstract void closeEntry(T var1) throws IOException;
}

