/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.container;

import java.io.File;
import java.net.URL;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.container.EnterpriseContainer;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.container.ContainerBase;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public abstract class EnterpriseContainerBase<T extends Archive<T>>
extends ContainerBase<T>
implements EnterpriseContainer<T> {
    protected EnterpriseContainerBase(Class<T> actualType, Archive<?> archive) {
        super(actualType, archive);
    }

    protected abstract ArchivePath getApplicationPath();

    public T setApplicationXML(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.setApplicationXML((Asset)new ClassLoaderAsset(resourceName));
    }

    public T setApplicationXML(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.setApplicationXML((Asset)new FileAsset(resource));
    }

    public T setApplicationXML(URL resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.setApplicationXML((Asset)new UrlAsset(resource));
    }

    public T setApplicationXML(Asset resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addAsApplicationResource(resource, "application.xml");
    }

    public T setApplicationXML(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        return this.setApplicationXML((Asset)new ClassLoaderAsset(classloaderResourceName));
    }

    public T addAsApplicationResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.addAsApplicationResource((Asset)new ClassLoaderAsset(resourceName), resourceName);
    }

    public T addAsApplicationResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addAsApplicationResource((Asset)new FileAsset(resource), resource.getName());
    }

    public T addAsApplicationResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addAsApplicationResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource((Asset)new FileAsset(resource), target);
    }

    public T addAsApplicationResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource((Asset)new UrlAsset(resource), target);
    }

    public T addAsApplicationResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource(resource, (ArchivePath)new BasicPath(target));
    }

    public T addAsApplicationResource(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addAsApplicationResource(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource((Asset)new FileAsset(resource), target);
    }

    public T addAsApplicationResource(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource((Asset)new UrlAsset(resource), target);
    }

    public T addAsApplicationResource(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        BasicPath location = new BasicPath(this.getApplicationPath(), target);
        return this.add(resource, location);
    }

    public T addAsApplicationResources(Package resourcePackage, String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNullAndNoNullValues(resourceNames, "ResourceNames must be specified and can not container null values");
        for (String resourceName : resourceNames) {
            this.addAsApplicationResource(resourcePackage, resourceName);
        }
        return this.covarientReturn();
    }

    public T addAsApplicationResource(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ArchivePath target = ArchivePaths.create((String)classloaderResourceName);
        return this.addAsApplicationResource(resourcePackage, resourceName, target);
    }

    public T addAsApplicationResource(Package resourcePackage, String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource(resourcePackage, resourceName, ArchivePaths.create((String)target));
    }

    public T addAsApplicationResource(Package resourcePackage, String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ClassLoaderAsset resource = new ClassLoaderAsset(classloaderResourceName);
        return this.addAsApplicationResource((Asset)resource, target);
    }

    protected abstract ArchivePath getModulePath();

    public T addAsModule(Archive<?> archive) throws IllegalArgumentException {
        Validate.notNull(archive, "Archive must be specified");
        return this.add(archive, this.getModulePath(), ZipExporter.class);
    }

    public T addAsModule(String resourceName) {
        Validate.notNull(resourceName, "ResourceName must be specified");
        BasicPath location = new BasicPath(AssetUtil.getNameForClassloaderResource(resourceName));
        return this.addAsModule(resourceName, (ArchivePath)location);
    }

    public T addAsModule(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addAsModule(resource, resource.getName());
    }

    public T addAsModules(Archive<?> ... archives) throws IllegalArgumentException {
        Validate.notNull(archives, "archives must be specified");
        for (Archive<?> archive : archives) {
            this.addAsModule(archive);
        }
        return this.covarientReturn();
    }

    public T addAsModules(String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourceNames, "resourceNames must be specified");
        for (String resourceName : resourceNames) {
            this.addAsModule(resourceName);
        }
        return this.covarientReturn();
    }

    public T addAsModules(File ... resources) throws IllegalArgumentException {
        Validate.notNull(resources, "resources must be specified");
        for (File resource : resources) {
            this.addAsModule(resource);
        }
        return this.covarientReturn();
    }

    public T addAsModule(File resource, ArchivePath targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        FileAsset asset = new FileAsset(resource);
        return this.addAsModule((Asset)asset, targetPath);
    }

    public T addAsModule(String resourceName, ArchivePath targetPath) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        ClassLoaderAsset asset = new ClassLoaderAsset(resourceName);
        return this.addAsModule((Asset)asset, targetPath);
    }

    public T addAsModule(URL resource, ArchivePath targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        UrlAsset asset = new UrlAsset(resource);
        return this.addAsModule((Asset)asset, targetPath);
    }

    public T addAsModule(File resource, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addAsModule(resource, (ArchivePath)new BasicPath(targetPath));
    }

    public T addAsModule(Asset resource, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addAsModule(resource, (ArchivePath)new BasicPath(targetPath));
    }

    public T addAsModule(String resourceName, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resourceName, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addAsModule(resourceName, (ArchivePath)new BasicPath(targetPath));
    }

    public T addAsModule(URL resource, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addAsModule(resource, (ArchivePath)new BasicPath(targetPath));
    }

    public T addAsModule(Asset resource, ArchivePath targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.add(resource, new BasicPath(this.getModulePath(), targetPath));
    }
}

