/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer.zip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.importer.ArchiveImportException;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.ZipFileEntryAsset;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public class ZipImporterImpl
extends AssignableBase<Archive<?>>
implements ZipImporter {
    public ZipImporterImpl(Archive<?> archive) {
        super(archive);
    }

    @Deprecated
    public ZipImporter importZip(ZipInputStream stream) {
        return this.importFrom(stream);
    }

    @Deprecated
    public ZipImporter importZip(ZipFile file) {
        return this.importFrom(file);
    }

    public ZipImporter importFrom(InputStream stream) throws ArchiveImportException {
        return this.importFrom(stream, (Filter<ArchivePath>)Filters.includeAll());
    }

    public ZipImporter importFrom(InputStream stream, Filter<ArchivePath> filter) throws ArchiveImportException {
        Validate.notNull(stream, "Stream must be specified");
        Validate.notNull(filter, "Filter must be specified");
        try {
            ZipEntry entry;
            ZipInputStream zipStream = new ZipInputStream(stream);
            while ((entry = zipStream.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (!filter.include((Object)ArchivePaths.create((String)entryName))) {
                    zipStream.closeEntry();
                    continue;
                }
                Object archive = this.getArchive();
                if (entry.isDirectory()) {
                    archive.addAsDirectory(entryName);
                    continue;
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
                IOUtil.copy(zipStream, output);
                archive.add((Asset)new ByteArrayAsset(output.toByteArray()), entryName);
                zipStream.closeEntry();
            }
        }
        catch (IOException e) {
            throw new ArchiveImportException("Could not import stream", (Throwable)e);
        }
        return this;
    }

    public ZipImporter importFrom(File file) throws ArchiveImportException {
        return this.importFrom(file, (Filter<ArchivePath>)Filters.includeAll());
    }

    public ZipImporter importFrom(File file, Filter<ArchivePath> filter) throws ArchiveImportException {
        ZipFile zipFile;
        Validate.notNull(file, "File must be specified");
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File to import as ZIP must not be a directory: " + file.getAbsolutePath());
        }
        Validate.notNull(filter, "Filter must be specified");
        try {
            zipFile = new ZipFile(file);
        }
        catch (IOException ioe) {
            throw new ArchiveImportException("Could not obtain ZIP File from File", (Throwable)ioe);
        }
        return this.importFrom(zipFile, filter);
    }

    public ZipImporter importFrom(ZipFile file) throws ArchiveImportException {
        return this.importFrom(file, (Filter<ArchivePath>)Filters.includeAll());
    }

    private ZipImporter importFrom(ZipFile file, Filter<ArchivePath> filter) throws ArchiveImportException {
        Validate.notNull(file, "File must be specified");
        try {
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!filter.include((Object)ArchivePaths.create((String)entryName))) continue;
                Object archive = this.getArchive();
                if (entry.isDirectory()) {
                    archive.addAsDirectory(entryName);
                    continue;
                }
                archive.add((Asset)new ZipFileEntryAsset(new File(file.getName()), entry), (ArchivePath)new BasicPath(entryName));
            }
        }
        catch (Exception e) {
            throw new ArchiveImportException("Could not import file", (Throwable)e);
        }
        finally {
            try {
                file.close();
            }
            catch (IOException iOException) {}
        }
        return this;
    }
}

