/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileStore;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.util.Collection;
import java.util.Map;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;

public class ShrinkWrapFileStore
extends FileStore {
    private static final String TYPE = "shrinkwrap";
    private final Archive<?> archive;

    public ShrinkWrapFileStore(Archive<?> archive) {
        if (archive == null) {
            throw new IllegalArgumentException("Underlying archive must be specified");
        }
        this.archive = archive;
    }

    @Override
    public String name() {
        return this.archive.getName();
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public long getTotalSpace() {
        return this.getUsableSpace() + this.getUsedSpace();
    }

    public long getUsedSpace() {
        long count = 0L;
        int bufferSize = 8192;
        Map contents = this.archive.getContent();
        Collection nodes = contents.values();
        for (Node node : nodes) {
            Asset asset = node.getAsset();
            if (asset == null) continue;
            BufferedInputStream in = new BufferedInputStream(asset.openStream(), 8192);
            byte[] buffer = new byte[8192];
            int read = 0;
            try {
                while ((read = ((InputStream)in).read(buffer)) != -1) {
                    count += (long)read;
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not count size of archive " + this.archive.getName() + " at " + asset, ioe);
            }
        }
        return count;
    }

    @Override
    public long getUsableSpace() {
        return Runtime.getRuntime().freeMemory();
    }

    @Override
    public long getUnallocatedSpace() {
        return this.getUsableSpace();
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        return BasicFileAttributeView.class.equals(type);
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        return "basic".equals(name);
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        return null;
    }

    @Override
    public Object getAttribute(String attribute) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support attributes.");
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for: " + this.archive;
    }
}

