/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.nio.file;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.nio.file.MemoryNamedAsset;
import org.jboss.shrinkwrap.api.nio.file.SeekableInMemoryByteChannel;
import org.jboss.shrinkwrap.impl.nio.file.ShrinkWrapDirectoryStream;
import org.jboss.shrinkwrap.impl.nio.file.ShrinkWrapFileAttributeView;
import org.jboss.shrinkwrap.impl.nio.file.ShrinkWrapFileAttributes;
import org.jboss.shrinkwrap.impl.nio.file.ShrinkWrapFileSystem;
import org.jboss.shrinkwrap.impl.nio.file.ShrinkWrapPath;

public class ShrinkWrapFileSystemProvider
extends FileSystemProvider {
    private static final Logger log = Logger.getLogger(ShrinkWrapFileSystemProvider.class.getName());
    private static final String SCHEME = "shrinkwrap";
    private static final String ENV_KEY_ARCHIVE = "archive";
    private final ConcurrentMap<String, ShrinkWrapFileSystem> createdFileSystems = new ConcurrentHashMap<String, ShrinkWrapFileSystem>();
    private final ReentrantLock createNewFsLock = new ReentrantLock();

    @Override
    public String getScheme() {
        return SCHEME;
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("URI must be specified");
        }
        if (env == null) {
            throw new IllegalArgumentException("Environment must be specified");
        }
        String scheme = uri.getScheme();
        if (!scheme.equals(SCHEME)) {
            throw new IllegalArgumentException(ShrinkWrapFileSystem.class.getSimpleName() + " supports URI with scheme " + SCHEME + " only.");
        }
        String id = uri.getHost();
        Archive archive = null;
        Object archiveArg = env.get(ENV_KEY_ARCHIVE);
        if (archiveArg != null) {
            try {
                archive = (Archive)Archive.class.cast(archiveArg);
                if (!archive.getId().equals(id)) {
                    throw new IllegalArgumentException("Specified archive " + archive.toString() + " does not have name matching the host of specified URI: " + uri.toString());
                }
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Found archive supplied by environment: " + archive.toString());
                }
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("Unexpected argument passed into environment under key archive: " + archiveArg);
            }
        }
        this.createNewFsLock.lock();
        ShrinkWrapFileSystem existsFs = (ShrinkWrapFileSystem)this.createdFileSystems.get(archive.getId());
        if (existsFs != null && existsFs.isOpen()) {
            throw new FileSystemAlreadyExistsException("File System for URI " + uri.toString() + " already exists: " + existsFs.toString());
        }
        if (existsFs != null && !existsFs.isOpen() && log.isLoggable(Level.FINE)) {
            log.fine("Attempting to create a file system for URI " + uri.toString() + ", and one has been made but is closed; it will be replaced by a new one.");
        }
        ShrinkWrapFileSystem newFs = new ShrinkWrapFileSystem(this, archive);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Created new filesystem: " + newFs.toString() + " for URI " + uri.toString());
        }
        this.createdFileSystems.put(archive.getId(), newFs);
        this.createNewFsLock.unlock();
        return newFs;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        FileSystem fs = (FileSystem)this.createdFileSystems.get(uri.getHost());
        if (fs == null) {
            throw new FileSystemNotFoundException("Could not find an open file system with URI: " + uri.toString() + "; try creating a new file system?");
        }
        return fs;
    }

    @Override
    public Path getPath(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI must be specified");
        }
        String id = uri.getHost();
        ShrinkWrapFileSystem fs = null;
        if (id != null && id.length() > 0) {
            fs = (ShrinkWrapFileSystem)this.createdFileSystems.get(id);
        }
        if (fs == null) {
            throw new FileSystemNotFoundException("Could not find a previously-created filesystem with URI: " + uri.toString());
        }
        if (!fs.isOpen()) {
            throw new FileSystemNotFoundException("File System for URI: " + uri.toString() + " is closed; create a new one to re-mount.");
        }
        String pathComponent = uri.getPath();
        ArchivePath archivePath = ArchivePaths.create((String)pathComponent);
        ShrinkWrapPath path = new ShrinkWrapPath(archivePath, fs);
        return path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Archive<?> archive = this.getArchive(path);
        ArchivePath archivePath = ArchivePaths.create((String)path.toString());
        MemoryNamedAsset channel = new MemoryNamedAsset(archivePath);
        if (options.contains(StandardOpenOption.CREATE) || options.contains(StandardOpenOption.CREATE_NEW) || options.contains(StandardOpenOption.WRITE)) {
            if (archive.contains(channel.getName())) {
                if (!options.contains(StandardOpenOption.APPEND)) throw new FileAlreadyExistsException(archivePath.get());
                channel.position(0L);
                InputStream in = archive.get(archivePath).getAsset().openStream();
                this.copy(in, (SeekableByteChannel)channel);
                in.close();
                archive.delete(archivePath);
                archive.add((NamedAsset)channel);
                return channel;
            } else {
                archive.add((NamedAsset)channel);
            }
            return channel;
        }
        Node node = archive.get(archivePath);
        if (node == null) {
            throw new IllegalArgumentException("No open options have been set, and cannot read a file that does not exist");
        }
        Asset asset = node.getAsset();
        if (asset == null) {
            throw new IllegalArgumentException("Cannot open a new channel to a path with existing directory: " + archivePath.get());
        }
        InputStream in = asset.openStream();
        SeekableInMemoryByteChannel outChannel = new SeekableInMemoryByteChannel();
        this.copy(in, (SeekableByteChannel)outChannel);
        outChannel.position(0L);
        return outChannel;
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        FileSystem fs = dir.getFileSystem();
        if (!(fs instanceof ShrinkWrapFileSystem)) {
            throw new IllegalArgumentException("Expected ShrinkWrap File System for Path: " + dir.toString());
        }
        return new ShrinkWrapDirectoryStream(dir, (ShrinkWrapFileSystem)fs, filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        Archive<?> archive = this.getArchive(dir);
        ArchivePath parent = ArchivePaths.create((String)dir.toString()).getParent();
        if (parent != null && !archive.contains(parent)) {
            throw new IOException("Cannot recursively create parent directories for: " + dir + "; instead invoke \"createDirectories\"");
        }
        archive.addAsDirectories(new String[]{dir.toString()});
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Created directory " + dir.toString() + " on " + archive.toString());
        }
    }

    @Override
    public void delete(Path path) throws IOException {
        boolean isDirectory;
        String pathString;
        assert (path != null) : "Path must be specified";
        Archive<?> archive = this.getArchive(path);
        if (!archive.contains(pathString = path.toString())) {
            throw new NoSuchFileException(path + " does not exist in " + archive);
        }
        boolean bl = isDirectory = archive.get(pathString).getAsset() == null;
        if (isDirectory && !archive.getContent((Filter)new Filter<ArchivePath>(){

            public boolean include(ArchivePath path) {
                String filterPathString = path.get();
                return filterPathString.startsWith(pathString) && !filterPathString.equals(pathString);
            }
        }).isEmpty()) {
            throw new DirectoryNotEmptyException(pathString);
        }
        archive.delete(pathString);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Deleted " + path.toString() + " from " + archive.toString());
        }
    }

    private Archive<?> getArchive(Path path) {
        assert (path != null) : "Path must be specified";
        FileSystem fs = path.getFileSystem();
        assert (fs != null) : "File system is null";
        if (!(fs instanceof ShrinkWrapFileSystem)) {
            throw new IllegalArgumentException("This path is not associated with a " + ShrinkWrapFileSystem.class.getSimpleName());
        }
        ShrinkWrapFileSystem swfs = (ShrinkWrapFileSystem)fs;
        Archive<?> archive = swfs.getArchive();
        assert (archive != null) : "No archive associated with file system";
        return archive;
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        Asset asset;
        if (source == null) {
            throw new IllegalArgumentException("source must be specified");
        }
        if (target == null) {
            throw new IllegalArgumentException("target must be specified");
        }
        if (!Files.exists(source, new LinkOption[0])) {
            throw new IllegalArgumentException("Source file doesn't exist: " + source.toString());
        }
        if (source == target) {
            return;
        }
        Archive<?> archive = this.getArchive(target);
        Node node = archive.get(target.toString());
        if (node != null && (asset = node.getAsset()) == null && node.getChildren().size() > 0) {
            throw new DirectoryNotEmptyException("Cannot move to non-empty directory: " + target.toString());
        }
        archive.move(source.toString(), target.toString());
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) throws IOException {
        FileSystem fs2;
        FileSystem fs1 = path1.getFileSystem();
        if (fs1 != (fs2 = path2.getFileSystem())) {
            return false;
        }
        String normalized1 = path1.normalize().toString();
        String normalized2 = path2.normalize().toString();
        return normalized1.equals(normalized2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        FileStore fileStore = path.getFileSystem().getFileStores().iterator().next();
        return fileStore;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        String desired;
        Archive<?> archive = this.getArchive(path);
        if (!archive.contains(desired = path.toString())) {
            throw new NoSuchFileException(desired);
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        if (path == null) {
            throw new IllegalArgumentException("path must be specified");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must be specified");
        }
        if (!type.isAssignableFrom(ShrinkWrapFileAttributeView.class)) {
            return null;
        }
        if (!(path instanceof ShrinkWrapPath)) {
            throw new IllegalArgumentException("Only " + ShrinkWrapPath.class.getSimpleName() + " is supported");
        }
        return (V)((FileAttributeView)type.cast(new ShrinkWrapFileAttributeView(new ShrinkWrapFileAttributes((ShrinkWrapPath)path, this.getArchive(path)))));
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path must be specified");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must be specified");
        }
        if (!type.isAssignableFrom(ShrinkWrapFileAttributes.class)) {
            throw new UnsupportedOperationException("Only supports " + ShrinkWrapFileAttributes.class.getSimpleName() + " type");
        }
        if (!(path instanceof ShrinkWrapPath)) {
            throw new IllegalArgumentException("Only " + ShrinkWrapPath.class.getSimpleName() + " is supported");
        }
        ShrinkWrapPath swPath = (ShrinkWrapPath)path;
        if (!((ShrinkWrapFileSystem)swPath.getFileSystem()).getArchive().contains(path.toString())) {
            throw new NoSuchFileException(path.toString());
        }
        BasicFileAttributes attributes = (BasicFileAttributes)type.cast(new ShrinkWrapFileAttributes((ShrinkWrapPath)path, this.getArchive(path)));
        return (A)attributes;
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("ShrinkWrap File Systems do not support attributes");
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("ShrinkWrap File Systems do not support attributes");
    }

    private void copy(InputStream in, SeekableByteChannel out) throws IOException {
        assert (in != null) : "InStream must be specified";
        assert (out != null) : "Channel must be specified";
        byte[] backingBuffer = new byte[4096];
        ByteBuffer byteBuffer = ByteBuffer.wrap(backingBuffer);
        int bytesRead = 0;
        while ((bytesRead = in.read(backingBuffer, 0, backingBuffer.length)) > -1) {
            byteBuffer.limit(bytesRead);
            out.write(byteBuffer);
            byteBuffer.clear();
        }
    }
}

