/*
 * Decompiled with CFR 0.152.
 */
package org.shrinkwrap.springboot.impl;

import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.shrinkwrap.springboot.api.SpringBootLayout;

public class SpringBootLayoutImpl
implements SpringBootLayout {
    public static final String JAR_LAUNCHER_CLASSNAME = "org.springframework.boot.loader.JarLauncher";
    public static final String WAR_LAUNCHER_CLASSNAME = "org.springframework.boot.loader.WarLauncher";
    private final String launcherClassName;
    private final ArchivePath bootInfPath;
    private final ArchivePath webInfPath;
    private final ArchivePath librariesPath;
    private final ArchivePath classesPath;
    private final ArchivePath webPath;

    public SpringBootLayoutImpl(String launcherClassName, String bootInfPath, String webInfPath, String librariesPath, String classesPath) {
        if (launcherClassName == null) {
            throw new IllegalArgumentException("launcherClassName cannot be null");
        }
        if (librariesPath == null) {
            throw new IllegalArgumentException("librariesPath cannot be null");
        }
        if (classesPath == null) {
            throw new IllegalArgumentException("classesPath cannot be null");
        }
        this.launcherClassName = launcherClassName;
        this.bootInfPath = bootInfPath != null ? ArchivePaths.create((String)bootInfPath) : null;
        this.webInfPath = webInfPath != null ? ArchivePaths.create((String)webInfPath) : null;
        this.librariesPath = ArchivePaths.create((String)librariesPath);
        this.classesPath = ArchivePaths.create((String)classesPath);
        this.webPath = ArchivePaths.create((String)classesPath, (String)"static");
    }

    public String getLauncherClassName() {
        return this.launcherClassName;
    }

    public ArchivePath getBootInfPath() {
        if (this.bootInfPath == null) {
            throw new UnsupportedOperationException();
        }
        return this.bootInfPath;
    }

    public ArchivePath getWebInfPath() {
        if (this.webInfPath == null) {
            throw new UnsupportedOperationException();
        }
        return this.webInfPath;
    }

    public ArchivePath getLibrariesPath() {
        return this.librariesPath;
    }

    public ArchivePath getClassesPath() {
        return this.classesPath;
    }

    public ArchivePath getWebPath() {
        return this.webPath;
    }
}

