/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.slf4j;

import org.jboss.logging.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public final class JBossLoggerAdapter
extends MarkerIgnoringBase
implements LocationAwareLogger {
    private static final long serialVersionUID = -1855332334983449117L;
    final Logger logger;

    JBossLoggerAdapter(Logger logger) {
        this.logger = logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String msg) {
        this.logger.trace((Object)msg);
    }

    public void trace(String format, Object arg) {
        if (this.logger.isTraceEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg);
            this.logger.trace((Object)msgStr);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.logger.isTraceEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.trace((Object)msgStr);
        }
    }

    public void trace(String format, Object[] argArray) {
        if (this.logger.isTraceEnabled()) {
            String msgStr = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            this.logger.trace((Object)msgStr);
        }
    }

    public void trace(String msg, Throwable t) {
        this.logger.trace((Object)msg, t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg) {
        this.logger.debug((Object)msg);
    }

    public void debug(String format, Object arg) {
        if (this.logger.isDebugEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg);
            this.logger.debug((Object)msgStr);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.logger.isDebugEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.debug((Object)msgStr);
        }
    }

    public void debug(String format, Object[] argArray) {
        if (this.logger.isDebugEnabled()) {
            String msgStr = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            this.logger.debug((Object)msgStr);
        }
    }

    public void debug(String msg, Throwable t) {
        this.logger.debug((Object)msg, t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String msg) {
        this.logger.info((Object)msg);
    }

    public void info(String format, Object arg) {
        if (this.logger.isInfoEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg);
            this.logger.info((Object)msgStr);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.logger.isInfoEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.info((Object)msgStr);
        }
    }

    public void info(String format, Object[] argArray) {
        if (this.logger.isInfoEnabled()) {
            String msgStr = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            this.logger.info((Object)msgStr);
        }
    }

    public void info(String msg, Throwable t) {
        this.logger.info((Object)msg, t);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        this.logger.warn((Object)msg);
    }

    public void warn(String format, Object arg) {
        String msgStr = MessageFormatter.format((String)format, (Object)arg);
        this.logger.warn((Object)msgStr);
    }

    public void warn(String format, Object arg1, Object arg2) {
        String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.logger.warn((Object)msgStr);
    }

    public void warn(String format, Object[] argArray) {
        String msgStr = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
        this.logger.warn((Object)msgStr);
    }

    public void warn(String msg, Throwable t) {
        this.logger.warn((Object)msg, t);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        this.logger.error((Object)msg);
    }

    public void error(String format, Object arg) {
        String msgStr = MessageFormatter.format((String)format, (Object)arg);
        this.logger.error((Object)msgStr);
    }

    public void error(String format, Object arg1, Object arg2) {
        String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.logger.error((Object)msgStr);
    }

    public void error(String format, Object[] argArray) {
        String msgStr = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
        this.logger.error((Object)msgStr);
    }

    public void error(String msg, Throwable t) {
        this.logger.error((Object)msg, t);
    }

    public void log(Marker marker, String callerFQCN, int level, String msg, Throwable t) {
        switch (level) {
            case 0: {
                this.logger.trace(callerFQCN, (Object)msg, t);
                break;
            }
            case 10: {
                this.logger.debug(callerFQCN, (Object)msg, t);
                break;
            }
            case 20: {
                this.logger.info(callerFQCN, (Object)msg, t);
                break;
            }
            case 30: {
                this.logger.warn(callerFQCN, (Object)msg, t);
                break;
            }
            case 40: {
                this.logger.error(callerFQCN, (Object)msg, t);
                break;
            }
            default: {
                throw new IllegalStateException("Level number " + level + " is not recognized.");
            }
        }
    }
}

