/*
 * JBoss, Home of Professional Open Source.
 *
 * Copyright 2020 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.slf4j.impl;

import org.jboss.slf4j.JBossMDCAdapter;
import org.slf4j.spi.MDCAdapter;

/**
 * This implementation is bound to {@link JBossMDCAdapter}.
 *
 * @author <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 * @version <tt>$Revision: 2784 $</tt>
 */
public class StaticMDCBinder
{
   public static final StaticMDCBinder SINGLETON = new StaticMDCBinder();

   private StaticMDCBinder()
   {
      // empty
   }
  
   public MDCAdapter getMDCA()
   {
      return new JBossMDCAdapter();
   }
  
   public String  getMDCAdapterClassStr()
   {
      return JBossMDCAdapter.class.getName();
   }
}
