/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.deployers;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.spring.deployers.SpringContextDescriptor;
import org.jboss.spring.deployers.SpringMetaData;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringParserDeployer
extends AbstractVFSParsingDeployer<SpringMetaData> {
    private boolean useLegacyDefaultName;

    public SpringParserDeployer() {
        super(SpringMetaData.class);
        this.setSuffix("-spring.xml");
        this.setJarExtension(".spring");
        this.setUseLegacyDefaultName(false);
    }

    protected boolean isUseLegacyDefaultName() {
        return this.useLegacyDefaultName;
    }

    public void setUseLegacyDefaultName(boolean useLegacyDefaultName) {
        this.useLegacyDefaultName = useLegacyDefaultName;
    }

    protected String getDefaultName(VirtualFile file) {
        String shortName = file.getName();
        int p = shortName.indexOf("-spring.xml");
        return shortName.substring(0, p);
    }

    protected String getDefaultName(VFSDeploymentUnit unit) {
        String shortName = unit.getSimpleName();
        int p = shortName.lastIndexOf(".");
        return shortName.substring(0, p);
    }

    protected SpringMetaData parse(VFSDeploymentUnit unit, VirtualFile file, SpringMetaData metaData) throws Exception {
        String defaultName = this.isUseLegacyDefaultName() ? this.getDefaultName(unit) : this.getDefaultName(file);
        return new SpringMetaData(Collections.singletonList(this.createSpringContextDescriptor(file, defaultName)));
    }

    private SpringContextDescriptor createSpringContextDescriptor(VirtualFile file, String defaultName) throws MalformedURLException, URISyntaxException {
        return new SpringContextDescriptor(file.toURL(), defaultName);
    }

    protected SpringMetaData handleMultipleFiles(VFSDeploymentUnit unit, SpringMetaData root, List<VirtualFile> files) throws Exception {
        ArrayList<SpringContextDescriptor> descriptors = new ArrayList<SpringContextDescriptor>();
        for (VirtualFile virtualFile : files) {
            if (this.isUseLegacyDefaultName()) {
                throw new IllegalStateException("Cannot use the legacy default name for multiple Spring configuration files");
            }
            String defaultName = this.getDefaultName(virtualFile);
            descriptors.add(new SpringContextDescriptor(virtualFile.toURL(), defaultName));
        }
        return new SpringMetaData(descriptors);
    }
}

