/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.callback;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.InvocationContext;
import org.jboss.spring.support.SpringInjectionSupport;

public class SpringPassivationInterceptor
extends SpringInjectionSupport
implements Serializable {
    private static final long serialVersionUID = -7259379236645796135L;

    @PostActivate
    public void postActivate(InvocationContext ctx) throws Exception {
        this.inject(ctx.getTarget());
        ctx.proceed();
    }

    @PrePassivate
    public void prePassivate(InvocationContext ctx) throws Exception {
        Field[] fields;
        for (Field f : fields = this.getAllFields(ctx.getTarget())) {
            boolean isSerializable = Serializable.class.isAssignableFrom(f.getType());
            boolean isTransient = Modifier.isTransient(f.getModifiers());
            if (isSerializable || isTransient) continue;
            f.setAccessible(true);
            f.set(ctx.getTarget(), null);
        }
        ctx.proceed();
    }

    @PreDestroy
    public void preDestroy(InvocationContext ctx) throws Exception {
        ctx.proceed();
    }
}

