/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.factory;

import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.jboss.spring.factory.Instantiable;
import org.jboss.spring.factory.Nameable;
import org.jboss.util.naming.Util;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.xml.sax.InputSource;

public class NamedXmlBeanFactory
extends DefaultListableBeanFactory
implements Nameable,
Instantiable {
    private String defaultName;
    private String name;
    private boolean instantiate;

    public NamedXmlBeanFactory(String defaultName, Resource resource) throws BeansException {
        this.initializeNames(resource);
        this.defaultName = defaultName;
    }

    @Override
    public String getName() {
        String name;
        String string = name = this.name != null ? this.name : this.defaultName;
        if (name == null) {
            throw new IllegalArgumentException("Bean factory JNDI name must be set!");
        }
        return name;
    }

    @Override
    public boolean doInstantiate() {
        return this.instantiate;
    }

    private void initializeNames(Resource resource) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    return "http://www.springframework.org/schema/beans";
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    return "beans";
                }

                public Iterator getPrefixes(String namespaceURI) {
                    return Collections.singleton("beans").iterator();
                }
            });
            String expression = "/beans:beans/beans:description";
            InputSource inputSource = new InputSource(resource.getInputStream());
            String description = xPath.evaluate(expression, inputSource);
            if (description != null) {
                Matcher inst;
                Matcher pbfm;
                Matcher bfm = Pattern.compile("BeanFactory=\\(([^)]+)\\)").matcher(description);
                if (bfm.find()) {
                    this.name = bfm.group(1);
                }
                if ((pbfm = Pattern.compile("ParentBeanFactory=\\(([^)]+)\\)").matcher(description)).find()) {
                    String parentName = pbfm.group(1);
                    try {
                        this.setParentBeanFactory((BeanFactory)Util.lookup((String)parentName, BeanFactory.class));
                    }
                    catch (Exception e) {
                        throw new BeanDefinitionStoreException("Failure during parent bean factory JNDI lookup: " + parentName, (Throwable)e);
                    }
                }
                if ((inst = Pattern.compile("Instantiate=\\(([^)]+)\\)").matcher(description)).find()) {
                    this.instantiate = Boolean.parseBoolean(inst.group(1));
                }
            }
            if (this.name == null || "".equals(StringUtils.trimAllWhitespace((String)this.name))) {
                this.name = this.defaultName;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

