/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.deployers;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.spring.deployers.SpringContextDescriptor;
import org.jboss.spring.deployers.SpringMetaData;
import org.jboss.spring.vfs.VFSUtil;

public class SpringParserDeployerHandler {
    boolean useLegacyDefaultName;

    protected boolean isUseLegacyDefaultName() {
        return this.useLegacyDefaultName;
    }

    public void setUseLegacyDefaultName(boolean useLegacyDefaultName) {
        this.useLegacyDefaultName = useLegacyDefaultName;
    }

    String getDefaultNameForFile(Object file) throws IOException {
        String shortName = (String)VFSUtil.invokeVfsMethod((Method)VFSUtil.VIRTUAL_FILE_METHOD_GET_NAME, (Object)file, (Object[])new Object[0]);
        int p = shortName.indexOf("-spring.xml");
        return shortName.substring(0, p);
    }

    String getDefaultNameForUnit(DeploymentUnit unit) {
        String shortName = unit.getSimpleName();
        int p = shortName.lastIndexOf(".");
        return shortName.substring(0, p);
    }

    public SpringMetaData parse(DeploymentUnit unit, Object file) throws IOException, URISyntaxException {
        String defaultName = this.isUseLegacyDefaultName() ? this.getDefaultNameForUnit(unit) : this.getDefaultNameForFile(file);
        return new SpringMetaData(Collections.singletonList(this.createSpringContextDescriptor(file, defaultName)));
    }

    private SpringContextDescriptor createSpringContextDescriptor(Object file, String defaultName) throws IOException {
        return new SpringContextDescriptor((URL)VFSUtil.invokeVfsMethod((Method)VFSUtil.VIRTUAL_FILE_METHOD_TO_URL, (Object)file, (Object[])new Object[0]), defaultName);
    }

    public SpringMetaData handleMultipleFiles(List<?> files) throws IOException {
        ArrayList<SpringContextDescriptor> descriptors = new ArrayList<SpringContextDescriptor>();
        for (Object virtualFile : files) {
            if (this.isUseLegacyDefaultName()) {
                throw new IllegalStateException("Cannot use the legacy default name for multiple Spring configuration files");
            }
            String defaultName = this.getDefaultNameForFile(virtualFile);
            descriptors.add(new SpringContextDescriptor((URL)VFSUtil.invokeVfsMethod((Method)VFSUtil.VIRTUAL_FILE_METHOD_TO_URL, virtualFile, (Object[])new Object[0]), defaultName));
        }
        return new SpringMetaData(descriptors);
    }
}

