/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.deployers.as7;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.filter.PathFilters;
import org.jboss.spring.deployers.as7.SpringDeployment;

public class SpringDependencyProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier MODULE_IDENTIFIER_SNOWDROP = ModuleIdentifier.create((String)"org.jboss.snowdrop");
    private static final ModuleIdentifier MODULE_IDENTIFIER_SPRING = ModuleIdentifier.create((String)"org.springframework.spring", (String)"snowdrop");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        SpringDeployment locations = SpringDeployment.retrieveFrom(deploymentUnit);
        if (locations == null || locations.getContextDefinitionLocations().isEmpty()) {
            return;
        }
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleDependency springDependency = this.getSpringDependency(moduleSpecification);
        if (springDependency == null) {
            springDependency = this.addDependency(MODULE_IDENTIFIER_SPRING, moduleSpecification);
        }
        springDependency.addExportFilter(PathFilters.getMetaInfFilter(), true);
        springDependency.addImportFilter(PathFilters.getMetaInfFilter(), true);
        this.addDependency(MODULE_IDENTIFIER_SNOWDROP, moduleSpecification);
        deploymentUnit.addToAttachmentList(Attachments.ADDITIONAL_ANNOTATION_INDEXES, (Object)MODULE_IDENTIFIER_SNOWDROP);
    }

    private ModuleDependency getSpringDependency(ModuleSpecification moduleSpecification) {
        for (ModuleDependency moduleDependency : moduleSpecification.getAllDependencies()) {
            if (!moduleDependency.getIdentifier().getName().equals(MODULE_IDENTIFIER_SPRING.getName())) continue;
            return moduleDependency;
        }
        return null;
    }

    private ModuleDependency addDependency(ModuleIdentifier moduleIdentifier, ModuleSpecification moduleSpecification) {
        ModuleDependency moduleDependency = new ModuleDependency(Module.getBootModuleLoader(), moduleIdentifier, false, false, true);
        moduleDependency.addExportFilter(PathFilters.getMetaInfFilter(), true);
        moduleDependency.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpecification.addUserDependency(moduleDependency);
        return moduleDependency;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

