/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.factory;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.jboss.spring.factory.Nameable;
import org.jboss.spring.factory.NamedXmlBeanDefinitionReader;
import org.jboss.spring.vfs.context.VFSClassPathXmlApplicationContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class NamedXmlApplicationContext
extends VFSClassPathXmlApplicationContext
implements Nameable {
    private String defaultName;
    private Resource resource;
    private NamedXmlBeanDefinitionReader beanDefinitionReader;
    private String name;

    public NamedXmlApplicationContext(String defaultName, Resource resource) throws BeansException {
        this(defaultName, resource, true);
    }

    public NamedXmlApplicationContext(String defaultName, Resource resource, boolean refresh) throws BeansException {
        super(new String[0], false);
        this.defaultName = defaultName;
        this.resource = resource;
        this.initializeNames(resource);
        if (refresh) {
            this.refresh();
        }
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        this.beanDefinitionReader = new NamedXmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        this.beanDefinitionReader.setResourceLoader((ResourceLoader)this);
        ClassLoader cl = this.getClassLoader();
        if (cl != null) {
            this.beanDefinitionReader.setBeanClassLoader(cl);
        }
        this.beanDefinitionReader.setEntityResolver((EntityResolver)new ResourceEntityResolver((ResourceLoader)this));
        this.initBeanDefinitionReader(this.beanDefinitionReader);
        this.loadBeanDefinitions(this.beanDefinitionReader);
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        reader.loadBeanDefinitions(this.resource);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void initializeNames(Resource resource) {
        try {
            Matcher bfm;
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    return "http://www.springframework.org/schema/beans";
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    return "beans";
                }

                public Iterator getPrefixes(String namespaceURI) {
                    return Collections.singleton("beans").iterator();
                }
            });
            String expression = "/beans:beans/beans:description";
            InputSource inputSource = new InputSource(resource.getInputStream());
            String description = xPath.evaluate(expression, inputSource);
            if (description != null && (bfm = Pattern.compile("BeanFactory=\\(([^)]+)\\)").matcher(description)).find()) {
                this.name = bfm.group(1);
            }
            if (this.name == null || "".equals(StringUtils.trimAllWhitespace((String)this.name))) {
                this.name = this.defaultName;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

