/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.deployers.as7;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.filter.PathFilters;
import org.jboss.spring.deployers.as7.SpringDeployment;

public class SpringDependencyProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier MODULE_IDENTIFIER_SNOWDROP = ModuleIdentifier.create((String)"org.jboss.snowdrop");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        SpringDeployment locations = SpringDeployment.retrieveFrom(deploymentUnit);
        if (locations == null || locations.getContextDefinitionLocations().isEmpty()) {
            return;
        }
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        this.addDependency(MODULE_IDENTIFIER_SNOWDROP, moduleSpecification);
        deploymentUnit.addToAttachmentList(Attachments.ADDITIONAL_ANNOTATION_INDEXES, (Object)MODULE_IDENTIFIER_SNOWDROP);
    }

    private ModuleDependency addDependency(ModuleIdentifier moduleIdentifier, ModuleSpecification moduleSpecification) {
        ModuleDependency moduleDependency = new ModuleDependency(Module.getBootModuleLoader(), moduleIdentifier, false, false, true);
        moduleDependency.addExportFilter(PathFilters.acceptAll(), true);
        moduleDependency.addImportFilter(PathFilters.acceptAll(), true);
        moduleSpecification.addUserDependency(moduleDependency);
        return moduleDependency;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

