/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.deployers.as7;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.spring.deployers.as7.ApplicationContextService;
import org.jboss.spring.deployers.as7.SpringDeployment;
import org.jboss.spring.factory.NamedXmlApplicationContext;
import org.jboss.spring.vfs.VFSResource;
import org.jboss.vfs.VirtualFile;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;

public class SpringBootstrapProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        SpringDeployment locations = SpringDeployment.retrieveFrom(phaseContext.getDeploymentUnit());
        if (locations == null) {
            return;
        }
        for (VirtualFile virtualFile : locations.getContextDefinitionLocations()) {
            NamedXmlApplicationContext applicationContext;
            EEModuleDescription moduleDescription = (EEModuleDescription)phaseContext.getDeploymentUnit().getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            boolean hasNamespaceContextSelector = moduleDescription != null && moduleDescription.getNamespaceContextSelector() != null;
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)((Module)phaseContext.getDeploymentUnit().getAttachment(org.jboss.as.server.deployment.Attachments.MODULE)).getClassLoader());
                if (hasNamespaceContextSelector) {
                    NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)moduleDescription.getNamespaceContextSelector());
                }
                applicationContext = new NamedXmlApplicationContext(phaseContext.getDeploymentUnit().getName(), (Resource)new VFSResource((Object)virtualFile));
                applicationContext.getName();
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
                if (hasNamespaceContextSelector) {
                    NamespaceContextSelector.popCurrentSelector();
                }
            }
            ApplicationContextService service = new ApplicationContextService((ConfigurableApplicationContext)applicationContext);
            ServiceName serviceName = phaseContext.getDeploymentUnit().getServiceName().append(new String[]{applicationContext.getName()});
            ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service);
            serviceBuilder.install();
            String jndiName = JndiName.of((String)"java:jboss").append(applicationContext.getName()).getAbsoluteName();
            int index = jndiName.indexOf("/");
            String namespace = index > 5 ? jndiName.substring(5, index) : null;
            String binding = index > 5 ? jndiName.substring(index + 1) : jndiName.substring(5);
            ServiceName naming = namespace != null ? ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{namespace}) : ContextNames.JAVA_CONTEXT_SERVICE_NAME;
            ServiceName bindingName = naming.append(new String[]{binding});
            BinderService binder = new BinderService(binding);
            InjectedValue injectedValue = new InjectedValue();
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
            serviceTarget.addService(bindingName, (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName})}).addInjection(binder.getManagedObjectInjector(), (Object)new ValueManagedReferenceFactory((Value)injectedValue)).addDependency(serviceName, ApplicationContext.class, (Injector)injectedValue).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binder.getNamingStoreInjector()).install();
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

