/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.vfs;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.jboss.spring.vfs.VFSResource;
import org.jboss.spring.vfs.VFSResourcePatternResolvingHelper;
import org.jboss.spring.vfs.VFSUtil;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

public class VFSServletContextResourcePatternResolver
extends ServletContextResourcePatternResolver {
    public VFSServletContextResourcePatternResolver(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    protected Resource[] findPathMatchingResources(String locationPattern) throws IOException {
        if (locationPattern.startsWith("classpath*:")) {
            locationPattern = locationPattern.substring("classpath*:".length());
            String rootDirPath = this.determineRootDir(locationPattern);
            Enumeration<URL> urls = this.getClassLoader().getResources(rootDirPath);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null || url.getProtocol().contains("vfs")) continue;
                return super.findPathMatchingResources("classpath*:" + locationPattern);
            }
            return VFSResourcePatternResolvingHelper.locateResources(locationPattern, rootDirPath, this.getClassLoader(), this.getPathMatcher(), false);
        }
        if (locationPattern.startsWith("classpath:")) {
            locationPattern = locationPattern.substring("classpath:".length());
            String rootDirPath = this.determineRootDir(locationPattern);
            URL url = this.getClassLoader().getResource(rootDirPath);
            if (url != null && !url.getProtocol().contains("vfs")) {
                return super.findPathMatchingResources("classpath:" + locationPattern);
            }
            return VFSResourcePatternResolvingHelper.locateResources(locationPattern, rootDirPath, this.getClassLoader(), this.getPathMatcher(), true);
        }
        return super.findPathMatchingResources(locationPattern);
    }

    protected Resource convertClassLoaderURL(URL url) {
        try {
            Object file = VFSUtil.invokeVfsMethod(VFSUtil.VFS_METHOD_GET_ROOT_URL, null, url);
            return new VFSResource(file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

